VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_Baeurer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
  Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SCREEN_NAME As String = "DPC_Baeurer"
Private Const SW_SHOWNORMAL = 1

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const LOCALE_USER_DEFAULT = &H400
Private Const C_ERRORRAISE As Long = 2500
Private Const C_MSG_ID_BASE As Long = 9700

Private Const ROWIDTRANSTATUS_NEW = "NEW"
Private Const ROWIDTRANSTATUS_OK = "OK"
Private Const ROWIDTRANSTATUS_ERROR = "ERROR"

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

#If ENV = LIVE Then
Private mo_FSO As Object
Private mo_Db As Object
Private mo_DbBaeurer As Object
Private mo_Shell As Object
#Else
Private mo_FSO As Scripting.FileSystemObject
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_DbBaeurer As ARMSYSCOMLib.ArmDb
Private mo_Shell As Object
#End If

Private mo_Tools As DPC_Tools

Private ml_U_Code As Long
Private ms_Language_Code As String
Private ms_CT_Code As String
Private ValidityDate As Date

Private ms_BaeurerServer As String
Private ms_BaeurerDatabase As String
Private ms_BaeurerLoginName As String
Private ms_BaeurerPassword As String
Private ml_BaeurerFi_Nr As Long
Private ms_BaeurerSource As String
Private ms_BaeurerLang As String
Private ms_PC_Name As String
Private mo_Generate As DPC_Generate
Private ml_BaeurerConnectID As Long

'Private me_RawMaterial As eDPCBOMMaterial
'Private ms_NewIdentNr As String
'Private ms_MaterialName As String
'Private md_CoilWidth As Double
'Private md_CoilThickness As Double
'Private ms_Material As String
'
'Private md_InlayLength As Double
'Private md_InlayWidth As Double

Private mta_XmlSql() As TXmlSql

Private Type TXmlSql
  Request As String
  Cursor As Long
  ATS_Id As Long
  ATS_Type As eDPCXmlSqlType
  ATS_Node As String
  ATS_IsSubNode As Boolean
  ATS_IsMaster As Boolean
  ATS_ImportName As String
  ATS_Profile As String
  ATS_Version As Long
End Type

' remarks - need DB user to write export tables and read all other
' when the result is ready ? which status to check ?
' how to send the same article to secretbox again ?
' is it possible to update article ?
' Link BOM to agpos fuer material abbuchung
' definier ag bennenung (nr:benennng)
' abw_plus = 500%

Public Property Set ArmDb(ByVal ao_Db As Object)
On Error GoTo ErrHandler
  
  Set mo_Db = ao_Db
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Property Get ArmDbBaeurer() As Object
On Error GoTo ErrHandler
  
  Set ArmDbBaeurer = mo_DbBaeurer
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDbBaeurer.Get")
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Property Let U_Code(al_Code As Long)
On Error GoTo ErrHandler
  
  ml_U_Code = al_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("U_Code.Let")
End Property

Property Let Language_Code(as_Language_Code As String)
On Error GoTo ErrHandler
  
  ms_Language_Code = as_Language_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Let")
End Property

Property Let CT_Code(as_Value As String)
On Error GoTo ErrHandler
  
  ms_CT_Code = as_Value
  Exit Property
ErrHandler:
  Call ErrorHandler("CT_Code.Let")
End Property


Public Sub Load_A_COM()
On Error GoTo ErrorHandler

Dim ls_TempDir As String
Dim ls_Connect() As String
Dim lo_NetObject As Object

  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  Set mo_FSO = CreateObject("Scripting.FileSystemObject")
  Set mo_Shell = CreateObject("WSCript.Shell")
  If mo_Shell Is Nothing Then
      Call Err.Raise(666, "CreateObject()", "Cannot create WSCript.Shell.")
  End If

  Set lo_NetObject = CreateObject("WScript.Network")
  ms_PC_Name = Left(lo_NetObject.ComputerName, 50)
  Set lo_NetObject = Nothing
  
  ls_TempDir = mo_Tools.GetAndCreateTempDir(mo_FSO, SCREEN_NAME)
  
#If ENV = LIVE Then
    Set mo_DbBaeurer = CreateObject("ArmSysCOM.ArmDb")
#Else
    Set mo_DbBaeurer = New ARMSYSCOMLib.ArmDb
#End If
  
  Set mo_Generate = New DPC_Generate
  Set mo_Generate.ArmDb = mo_Db
  Set mo_Generate.Tools = mo_Tools
  
  ls_Connect = Split(mo_Tools.GetAConfigData("DPC_BaeurerConnection"), SEP)
  If UBound(ls_Connect) = 5 Then
    ms_BaeurerServer = ls_Connect(0)
    ms_BaeurerDatabase = ls_Connect(1)
    ms_BaeurerLoginName = ls_Connect(2)
    ms_BaeurerPassword = ls_Connect(3)
    ms_BaeurerSource = ls_Connect(4)
    ml_BaeurerFi_Nr = Val(ls_Connect(5))
    ms_BaeurerLang = "de_de"
  Else
      Err.Raise ArmErr.PropertyNotSet, "Split(mo_Tools.GetAConfigData(""DPC_BaeurerConnection"")", "Missing or invalid configuration"
  End If
  ml_BaeurerConnectID = 0
'    ms_BaeurerServer = "10.68.16.40\LIVE_SAGE"
'    ms_BaeurerDatabase = "test70"
'    ms_BaeurerLoginName = "test70"
'    ms_BaeurerPassword = "erp"
'    ms_BaeurerSource = "Capture"
'    ml_BaeurerFi_Nr = 1
  If ms_Language_Code = "" Then ms_Language_Code = "E"
  Exit Sub
ErrorHandler:
  Call ErrorHandler("Load_A_Com")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrorHandler

Dim ll_Idx As Long

  Call mo_Tools.DeleteTemporaryFolder(mo_FSO, SCREEN_NAME)
  If mo_DbBaeurer.CursorCount > 0 Then
    For ll_Idx = 0 To mo_DbBaeurer.CursorCount - 1
      Debug.Print "Baeurer Cursor #" & (ll_Idx + 1) & "-" & mo_DbBaeurer.Cursors(ll_Idx) & mo_DbBaeurer.SQLRequest(mo_DbBaeurer.Cursors(ll_Idx))
    Next
  End If
  Call mo_DbBaeurer.Disconnect
  Set mo_FSO = Nothing
  Set mo_Db = Nothing
  Set mo_DbBaeurer = Nothing
  Exit Sub
ErrorHandler:
  Call ErrorHandler("Unload_A_Com")
End Sub

Private Sub LoadGrid(ByVal ao_grid As ArmGrid, ByVal ac_Cursor As Long)
On Error GoTo ErrorHandler

  ao_grid.Redraw = False
  Call mo_DbBaeurer.First(ac_Cursor)
  While Not mo_DbBaeurer.EOF(ac_Cursor)
    Call ao_grid.AddLine(Array(mo_DbBaeurer.GetFields(ac_Cursor, 0), mo_DbBaeurer.GetFields(ac_Cursor, 1)))
    Call mo_DbBaeurer.Next(ac_Cursor)
  Wend
  ao_grid.Redraw = True
  Exit Sub
ErrorHandler:
  Call ErrorHandler("LoadGrid")
End Sub

Private Function LoadBaeurerReferenceCursor(ByVal ao_Db As Object, ByVal ae_Reference As eDPCBaeurerReference, ByVal as_code As String, ByVal av_Param As Variant) As Long
On Error GoTo ErrorHandler

Dim ls_req As String
Dim ll_Idx As Long
  
  LoadBaeurerReferenceCursor = 0
  ls_req = ""
  If ae_Reference = eDPCBaeurerReference.brOrderType Then
    ls_req = "SELECT v902.auf_art as Code, v9022.txt AS Text "
    ls_req = ls_req & "FROM v902 "
    ls_req = ls_req & "INNER JOIN v9022 ON (v9022.auf_art=v902.auf_art AND v9022.fi_nr=v902.fi_nr and v9022.lang=$lang$) "
    ls_req = ls_req & "WHERE v902.fi_nr=$fi_nr$ AND "
    ls_req = ls_req & "((v902.auf_art=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brPartner Then
    ls_req = "SELECT g620.ansprnr as Code, g620.name_1 AS Text "
    ls_req = ls_req & "FROM g620 "
    ls_req = ls_req & "WHERE g620.fi_nr=$fi_nr$ AND "
    ls_req = ls_req & "g620.konto=$konto$ AND "
    ls_req = ls_req & "((g620.ansprnr=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brDeliveryCondition Then
    ls_req = "SELECT v908.lb as Code, v9082.txt AS Text "
    ls_req = ls_req & "FROM v908 "
    ls_req = ls_req & "INNER JOIN v9082 ON (v9082.lb=v908.lb AND v9082.fi_nr=v908.fi_nr and v9082.lang_ext=$lang$) "
    ls_req = ls_req & "WHERE v908.fi_nr=$fi_nr$ AND "
    ls_req = ls_req & "((v908.lb=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brDeliveryType Then
    ls_req = "SELECT v907.vers_art as Code, v9072.txt AS Text "
    ls_req = ls_req & "FROM v907 "
    ls_req = ls_req & "INNER JOIN v9072 ON (v9072.vers_art=v907.vers_art AND v9072.fi_nr=v907.fi_nr and v9072.lang_ext=$lang$) "
    ls_req = ls_req & "WHERE (v907.fi_nr=$fi_nr$) AND "
    ls_req = ls_req & "((v907.vers_art=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brClerkInCharge Then
    ls_req = "SELECT g915.sb_schl as Code, g915.sb_name AS Text "
    ls_req = ls_req & "FROM g915 "
    ls_req = ls_req & "WHERE g915.fi_nr=$fi_nr$ AND "
    ls_req = ls_req & "((g915.sb_schl=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brPackType Then
    ls_req = "SELECT g741.ausprid as Code, g7412.txt AS Text "
    ls_req = ls_req & "FROM g741 "
    ls_req = ls_req & "INNER JOIN g7412 ON (g741.kritnr = g7412.kritnr AND g741.ausprid = g7412.ausprid AND g7412.lang_ext=$lang$) "
    ls_req = ls_req & "INNER JOIN g730 ON (g7412.kritnr = g730.kritnr) "
    ls_req = ls_req & "WHERE g730.fldname = 'VERP_ART' AND "
    ls_req = ls_req & "((g741.ausprid=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brKonto Then
    ls_req = "SELECT v600.konto as Code, g693.name_1 AS Text "
    ls_req = ls_req & "FROM g600 "
    ls_req = ls_req & "INNER JOIN v600 ON (g600.konto = v600.konto) "
    ls_req = ls_req & "INNER JOIN g693 ON (g600.adressid = g693.adressid) "
    ls_req = ls_req & "WHERE (g600.fi_nr=$fi_nr$) AND "
    ls_req = ls_req & "(g600.satzart = 1) AND "
    ls_req = ls_req & "((g600.konto=$Code$) OR ($Code$ IS NULL))"
  End If
  
  If ls_req <> "" Then
    If IsArray(av_Param) Then
      For ll_Idx = 0 To UBound(av_Param) Step 2
        ls_req = Replace(ls_req, av_Param(ll_Idx), av_Param(ll_Idx + 1), , , vbTextCompare)
      Next
    End If
    ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
    ls_req = Replace(ls_req, "$Code$", as_code, , , vbTextCompare)
    ls_req = Replace(ls_req, "$lang$", mo_Tools.SQLStr(ms_BaeurerLang), , , vbTextCompare)
    LoadBaeurerReferenceCursor = mo_Tools.OpenSQLSafe(ao_Db, ls_req)
  End If
  Exit Function
ErrorHandler:
  Call ErrorHandler("LoadBaeurerReferenceCursor")
End Function

Public Function LoadBaeurerReferenceText(ByVal ae_Reference As eDPCBaeurerReference, ByVal as_code As String, ByVal av_Param As Variant) As String
On Error GoTo ErrorHandler

Dim lc_Cursor As Long

  LoadBaeurerReferenceText = ""
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
  lc_Cursor = LoadBaeurerReferenceCursor(mo_DbBaeurer, ae_Reference, as_code, av_Param)
  If lc_Cursor <> 0 Then
    If mo_DbBaeurer.RowCount(lc_Cursor) = 1 Then
      LoadBaeurerReferenceText = mo_DbBaeurer.GetFields(lc_Cursor, "Text")
    End If
    Call mo_DbBaeurer.Close(lc_Cursor)
  End If
  Exit Function
ErrorHandler:
  Call ErrorHandler("LoadReferenceGrid")
End Function


Public Sub LoadBaeurerReferenceGrid(ByVal ao_grid As ArmGrid, ByVal ae_Reference As eDPCBaeurerReference, ByVal av_Param As Variant)
On Error GoTo ErrorHandler

Dim lc_Cursor As Long

  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Sub
  End If
  
  lc_Cursor = LoadBaeurerReferenceCursor(mo_DbBaeurer, ae_Reference, "NULL", av_Param)
  Call ao_grid.ClearGrid
  If lc_Cursor <> 0 Then
    Call LoadGrid(ao_grid, lc_Cursor)
    Call mo_DbBaeurer.Close(lc_Cursor)
  End If
  Exit Sub
ErrorHandler:
  Call ErrorHandler("LoadBaeurerReferenceGrid")
End Sub

Public Function SaveXMLDocument(ByVal ao_XML As Object, ByVal as_FileName As String)
On Error GoTo ErrorHandler

Dim lo_shell As Object
Dim ls_XmlPath As String

  Set lo_shell = CreateObject("WSCript.Shell")
  If lo_shell Is Nothing Then
      Call Err.Raise(666, "CreateObject()", "Cannot create WSCript.Shell.")
  End If
  
  ls_XmlPath = App.Path & "\" & as_FileName & ".XML"
  Call ao_XML.Save(ls_XmlPath)
  Call lo_shell.Run("""" & ls_XmlPath & """")
  Set lo_shell = Nothing
  Exit Function
ErrorHandler:
  Call ErrorHandler("SaveXMLDocument")
End Function

Public Function CreateXMLDocument(ByVal ao_Db As Object, ByVal ae_ATR_Id As eDPCXmlExportType, ByVal as_key As String, ByRef al_Version As Long, ByVal ao_CustomData As Dictionary) As Object
On Error GoTo ErrorHandler

Dim lo_ParentNode As Object
Dim lo_MainNode As Object
Dim lc_CursorMaster As Long
Dim lc_CursorXML As Long
Dim ll_ATS_Id As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument

  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  lo_XMLDoc.async = False
  
  Set lo_ParentNode = lo_MainNode
  lc_CursorXML = GetXmlCursor(ae_ATR_Id)
  Call InitSqlData(ao_Db, lc_CursorXML, as_key)
  
  lt_XmlMaster = GetXmlMasterSql
  al_Version = lt_XmlMaster.ATS_Version
  
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "Data", "")
  Set lo_MainNode = AppendElement(lo_XMLDoc, lo_MainNode, lt_XmlMaster.ATS_ImportName, "")
  
  Call AppendElement(lo_XMLDoc, lo_MainNode, "heute", FormatXMLDateTime(Now))
  Call AppendElement(lo_XMLDoc, lo_MainNode, "profil", lt_XmlMaster.ATS_Profile)
  
  lc_CursorMaster = lt_XmlMaster.Cursor
  If ao_Db.RowCount(lc_CursorMaster) = 0 Then
    Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, lt_XmlMaster.ATS_Node, "")
  Else
    Call ao_Db.First(lc_CursorMaster)
    While Not ao_Db.EOF(lc_CursorMaster)
      Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, lt_XmlMaster.ATS_Node, "")
    
      Call mo_Db.First(lc_CursorXML)
      While Not mo_Db.EOF(lc_CursorXML)
      
        ll_ATS_Id = mo_Db.GetFields(lc_CursorXML, "ATS_Id")
        lt_XmlSql = GetXmlSql(ll_ATS_Id)
        If ll_ATS_Id = lt_XmlMaster.ATS_Id Then
          Call CreateXMLNode(lc_CursorXML, ao_Db, lc_CursorMaster, lo_XMLDoc, lo_ParentNode, ao_CustomData)
          Call mo_Db.Next(lc_CursorXML)
        Else
          If lt_XmlSql.ATS_Type = eDPCXmlSqlType.stList Then
            Call CreateXMLGroupList(lc_CursorXML, ao_Db, ll_ATS_Id, lo_XMLDoc, lo_ParentNode, ao_CustomData)
          ElseIf lt_XmlSql.ATS_Type = eDPCXmlSqlType.stFlat Then
            Call CreateXMLGroupFlat(lc_CursorXML, ao_Db, ll_ATS_Id, lo_XMLDoc, lo_ParentNode, ao_CustomData)
          End If
        End If
      Wend
      Call ao_Db.Next(lc_CursorMaster)
    Wend
  End If
  Call mo_Db.Close(lc_CursorXML)
  Call CloseSqlData(ao_Db)
  Set CreateXMLDocument = lo_XMLDoc
  Exit Function
ErrorHandler:
  Call ErrorHandler("CreateXMLDocument")
End Function

Private Function CreateXMLGroupFlat(ByVal ac_CursorXML As Long, ByVal ao_DbData As Object, ByVal al_ATS_Id As Long, ByVal ao_XMLDoc As Object, ByVal ao_parentNode As Object, ByVal ao_CustomData As Dictionary)
On Error GoTo ErrorHandler

Dim ll_RecIdx As Long
Dim lo_CurrentNode As Object
Dim ls_NodeName As String
Dim lt_XmlSql As TXmlSql
Dim lc_CursorData As Long

  lt_XmlSql = GetXmlSql(al_ATS_Id)
  lc_CursorData = lt_XmlSql.Cursor

  ls_NodeName = Trim(mo_Db.GetFields(ac_CursorXML, "ATS_Node"))
  If mo_Db.GetFields(ac_CursorXML, "ATS_IsSubNode") = "X" Then
    ls_NodeName = Replace(ls_NodeName, "$N$", CStr(ll_RecIdx), , , vbTextCompare)
    Set lo_CurrentNode = AppendElement(ao_XMLDoc, ao_parentNode, ls_NodeName, "")
  Else
    Set lo_CurrentNode = ao_parentNode
  End If
  While (Not mo_Db.EOF(ac_CursorXML)) And (al_ATS_Id = mo_Db.GetFields(ac_CursorXML, "ATS_Id"))
    ll_RecIdx = mo_Db.GetFields(ac_CursorXML, "ATR_RecIdx")
    If (ll_RecIdx > 0) And (ll_RecIdx <= ao_DbData.RowCount(lc_CursorData)) Then
      mo_Db.Position(lc_CursorData) = ll_RecIdx - 1
      Call CreateXMLNode(ac_CursorXML, ao_DbData, lc_CursorData, ao_XMLDoc, lo_CurrentNode, ao_CustomData)
    Else
      Call CreateXMLNode(ac_CursorXML, ao_DbData, 0, ao_XMLDoc, lo_CurrentNode, ao_CustomData)
    End If
    Call mo_Db.Next(ac_CursorXML)
  Wend
  Exit Function
ErrorHandler:
  Call ErrorHandler("CreateXMLGroupFlat")
End Function

Private Function CreateXMLGroupList(ByVal ac_CursorXML As Long, ByVal ao_DbData As Object, ByVal al_ATS_Id As Long, ByVal ao_XMLDoc As Object, ByVal ao_parentNode As Object, ByVal ao_CustomData As Dictionary)
On Error GoTo ErrorHandler

Dim ll_XMLPosition As Long
Dim ll_RecIdx As Long
Dim lo_CurrentNode As Object
Dim ls_NodeName As String
Dim lt_XmlSql As TXmlSql
Dim lc_CursorData As Long

  lt_XmlSql = GetXmlSql(al_ATS_Id)
  lc_CursorData = lt_XmlSql.Cursor
  
  ll_XMLPosition = mo_Db.Position(ac_CursorXML)
  
  If mo_Db.RowCount(lc_CursorData) = 0 Then
    'skip group if no data
    While (Not mo_Db.EOF(ac_CursorXML)) And (al_ATS_Id = mo_Db.GetFields(ac_CursorXML, "ATS_Id"))
      Call mo_Db.Next(ac_CursorXML)
    Wend
  Else
    Call ao_DbData.First(lc_CursorData)
    While Not ao_DbData.EOF(lc_CursorData)
      mo_Db.Position(ac_CursorXML) = ll_XMLPosition
      ll_RecIdx = mo_Db.Position(lc_CursorData) + 1
      ls_NodeName = Trim(mo_Db.GetFields(ac_CursorXML, "ATS_Node"))
      
      If mo_Db.GetFields(ac_CursorXML, "ATS_IsSubNode") = "X" Then
        ls_NodeName = Replace(ls_NodeName, "$N$", CStr(ll_RecIdx), , , vbTextCompare)
        Set lo_CurrentNode = AppendElement(ao_XMLDoc, ao_parentNode, ls_NodeName, "")
      Else
        Set lo_CurrentNode = ao_parentNode
      End If
      
      While (Not mo_Db.EOF(ac_CursorXML)) And (al_ATS_Id = mo_Db.GetFields(ac_CursorXML, "ATS_Id"))
        
        Call CreateXMLNode(ac_CursorXML, ao_DbData, lc_CursorData, ao_XMLDoc, lo_CurrentNode, ao_CustomData)
        
        Call mo_Db.Next(ac_CursorXML)
      Wend
      Call ao_DbData.Next(lc_CursorData)
    Wend
  End If
  Exit Function
ErrorHandler:
  Call ErrorHandler("CreateXMLGroupList")
End Function

'Private Function ReplaceMaterialValues(ByVal as_Value As String) As String
'On Error GoTo errorHandler
'
'  If me_RawMaterial = eDPCBOMMaterial.bcCoil Then
'    as_Value = Replace(as_Value, "$IdentNr$", FormatXML(ms_NewIdentNr, "C", 0), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$ben$", FormatXML(ms_MaterialName, "C", 0), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$werkstoff$", FormatXML(ms_Material, "C", 0), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$breiteb$", FormatXML(md_CoilWidth, "N", 2), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$matdicke$", FormatXML(md_CoilThickness, "N", 2), , , vbTextCompare)
'
'
'  ElseIf me_RawMaterial = eDPCBOMMaterial.bcInlay Then
'    as_Value = Replace(as_Value, "$IdentNr$", FormatXML(ms_NewIdentNr, "C", 0), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$ben$", FormatXML(ms_MaterialName, "C", 0), , , vbTextCompare)
'  End If
'  ReplaceMaterialValues = as_Value
'  Exit Function
'errorHandler:
'  Call errorHandler("ReplaceMaterialValues")
'End Function

Private Function ReplaceCustomData(ByVal as_Value As String, ByVal ao_CustomData As Dictionary, ByVal as_DataType As String, ByVal al_DataLength As Long, al_DataPrecision As Long) As String
On Error GoTo ErrorHandler

Dim ll_Idx As Long

  For ll_Idx = 0 To ao_CustomData.Count - 1
    If StrComp(as_Value, ao_CustomData.keys(ll_Idx), vbTextCompare) = 0 Then
      as_Value = Replace(as_Value, ao_CustomData.keys(ll_Idx), FormatXML(ao_CustomData.Items(ll_Idx), as_DataType, al_DataPrecision), , , vbTextCompare)
      Exit For
    End If
  Next
  ReplaceCustomData = as_Value
  Exit Function
ErrorHandler:
  Call ErrorHandler("ReplaceCustomData")
End Function

Private Function CreateXMLNode(ByVal ac_CursorXML As Long, ByVal ao_Db As Object, ByVal ac_CursorData As Long, ByVal ao_XMLDoc As Object, ByVal ao_parentNode As Object, ByVal ao_CustomData As Dictionary)
On Error GoTo ErrorHandler

Dim ls_DataType As String
Dim ll_DataLength As Long
Dim ll_DataPrecision As Long
Dim ls_Name As String
Dim ll_Idx As Long
Dim ls_value As String
Dim ls_Default As String
Dim ls_CodeLookup As String
Dim le_ATR_Type As eDPCXmlExportType

  ls_Default = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DefaultValue"))
  ls_value = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_Value"))
  ls_DataType = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataType"))
  ll_DataLength = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataLength"))
  ll_DataPrecision = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataPrecision"))
  ls_CodeLookup = Trim(mo_Db.GetFields(ac_CursorXML, "AC_CodeLookup"))
  le_ATR_Type = mo_Db.GetFields(ac_CursorXML, "ATR_Type")
  
  If Left(ls_Default, 1) = "'" And right(ls_Default, 1) = "'" Then
    ls_Default = Mid(ls_Default, 2, Len(ls_Default) - 2)
  End If
  
  If ls_value = "" Then
    ls_value = ls_Default
  Else
    If ac_CursorData = 0 Then
      ls_value = ""
    Else
      ls_value = Replace(ls_value, "$RowIndex$", CStr(ao_Db.Position(ac_CursorData) + 1), , , vbTextCompare)
      If Not ao_CustomData Is Nothing Then
        ls_value = ReplaceCustomData(ls_value, ao_CustomData, ls_DataType, ll_DataLength, ll_DataPrecision)
      End If
      For ll_Idx = 0 To ao_Db.FieldCount(ac_CursorData) - 1
        ls_Name = "$" & ao_Db.GetFieldName(ac_CursorData, ll_Idx) & "$"
        If StrComp(ls_value, ls_Name, vbTextCompare) = 0 Then
          If ls_CodeLookup = "" Then
            ls_value = FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), ls_DataType, ll_DataPrecision)
          Else
            ls_value = mo_Tools.ConvertCodeToBaeurer(mo_Db, mo_Tools.GetConversionCode(ls_CodeLookup), ao_Db.GetFields(ac_CursorData, ll_Idx))
            ls_value = FormatXML(ls_value, ls_DataType, ll_DataPrecision)
          End If
          Exit For
        ElseIf InStr(1, ls_value, ls_Name, vbTextCompare) > 0 Then
          If ao_Db.GetFieldType(ac_CursorData, ll_Idx) = ArmSysType.DBTYPE_I4 Then
            ls_value = Replace(ls_value, ls_Name, FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), "N", 0), , , vbTextCompare)
          ElseIf (ao_Db.GetFieldType(ac_CursorData, ll_Idx) = ArmSysType.DBTYPE_R4) Or (ao_Db.GetFieldType(ac_CursorData, ll_Idx) = ArmSysType.DBTYPE_R8) Then
            ls_value = Replace(ls_value, ls_Name, FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), "N", 2), , , vbTextCompare)
          ElseIf (ao_Db.GetFieldType(ac_CursorData, ll_Idx) = ArmSysType.DBTYPE_DATE) Then
            ls_value = Replace(ls_value, ls_Name, FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), "D", 0), , , vbTextCompare)
          Else
            ls_value = Replace(ls_value, ls_Name, FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), "C", 0), , , vbTextCompare)
          End If
        End If
      Next
    End If
    If Left(ls_value, 1) = "$" And right(ls_value, 1) = "$" Then
      ls_value = ls_Default
    End If
  End If
  Call AppendElement(ao_XMLDoc, ao_parentNode, mo_Db.GetFields(ac_CursorXML, "ATR_B7Name"), ls_value)
  Exit Function
ErrorHandler:
  Call ErrorHandler("CreateXMLNode")
End Function

Private Function FormatXML(ByVal av_Data As Variant, ByVal as_DataType As String, ByVal al_DataPrecision As Long)
On Error GoTo ErrorHandler

  FormatXML = ""
  Select Case UCase(as_DataType)
  Case "N"
    If al_DataPrecision = 0 Then
      FormatXML = FormatXMLInt(Val(av_Data))
    Else
      FormatXML = FormatXMLFloat(av_Data, al_DataPrecision)
    End If
  Case "D"
    FormatXML = FormatXMLDateTime(av_Data)
  Case Else
    FormatXML = CStr(av_Data)
  End Select
  Exit Function
ErrorHandler:
  Call ErrorHandler("FormatXML")
End Function

Private Function GetXmlCursor(ByVal ae_ATR_Type As eDPCXmlExportType) As Long
On Error GoTo ErrorHandler

Dim ls_Request As String

  ls_Request = "exec DPC_AttribXML_lst $ATR_Type$"
'    "SELECT ATR.ATR_Id, ATR.ATR_B7Name, ATR.ATR_Value, ATR.ATR_DefaultValue, ATR.ATR_DataType, ATR.ATR_DataLength, ATR.ATR_DataPrecision, ATR.ATR_RecIdx, ATR.AC_CodeLookup," & _
'    "ATS.ATS_Id, ATS.ATS_Sql, ATS.ATS_Type, ATS.ATS_RowCount, ATS.ATS_Node, ATS.ATS_IsSubNode, ATS.ATS_IsMaster, ATS.ATS_ImportName, ATS.ATS_Profile, ATS.ATS_Version  " & _
'    "FROM DPC_AttribXML ATR " & _
'    "INNER JOIN DPC_AttribXmlSql ATS ON (ATR.ATS_Id=ATS.ATS_Id) " & _
'    "WHERE ATR.ATR_B7Name <> '' AND " & _
'    "ATR.ATR_Type=$ATR_Type$ AND " & _
'    "ATR.Drop_Flag='' " & _
'    "ORDER BY ATR.ATR_Order"
  ls_Request = Replace(ls_Request, "$ATR_Type$", mo_Tools.SqlInt(ae_ATR_Type), , , vbTextCompare)
  GetXmlCursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  Exit Function
ErrorHandler:
  Call ErrorHandler("GetXmlCursor")
End Function

Private Sub InitSqlData(ByVal ao_Db As Object, ByVal ac_XmlCursor As Long, ByVal as_key As String)
On Error GoTo ErrorHandler

Dim ll_Idx As Long
Dim lc_Cursor As Long
Dim ll_RowCount As Long
Dim ls_Request As String

  ReDim mta_XmlSql(-1 To -1)
  lc_Cursor = mo_Db.Distinct(ac_XmlCursor, Array("ATS_Id", "ATS_Sql", "ATS_Type", "ATS_Node", "ATS_IsSubNode", "ATS_IsMaster", "ATS_ImportName", "ATS_Profile", "ATS_Version"), False)
  ll_RowCount = mo_Db.RowCount(lc_Cursor)
  If ll_RowCount > 0 Then
    ReDim mta_XmlSql(ll_RowCount - 1)
    Call mo_Db.First(lc_Cursor)
    ll_Idx = 0
    While Not mo_Db.EOF(lc_Cursor)
      mta_XmlSql(ll_Idx).ATS_Id = mo_Db.GetFields(lc_Cursor, "ATS_Id")
      mta_XmlSql(ll_Idx).Request = mo_Db.GetFields(lc_Cursor, "ATS_Sql")
      mta_XmlSql(ll_Idx).ATS_Type = mo_Db.GetFields(lc_Cursor, "ATS_Type")
      mta_XmlSql(ll_Idx).ATS_Node = mo_Db.GetFields(lc_Cursor, "ATS_Node")
      mta_XmlSql(ll_Idx).ATS_IsSubNode = StrComp(mo_Db.GetFields(lc_Cursor, "ATS_IsSubNode"), "X", vbTextCompare) = 0
      mta_XmlSql(ll_Idx).ATS_IsMaster = StrComp(mo_Db.GetFields(lc_Cursor, "ATS_IsMaster"), "X", vbTextCompare) = 0
      mta_XmlSql(ll_Idx).ATS_ImportName = mo_Db.GetFields(lc_Cursor, "ATS_ImportName")
      mta_XmlSql(ll_Idx).ATS_Profile = mo_Db.GetFields(lc_Cursor, "ATS_Profile")
      mta_XmlSql(ll_Idx).ATS_Version = mo_Db.GetFields(lc_Cursor, "ATS_Version")
      
      ls_Request = Replace(mta_XmlSql(ll_Idx).Request, "$Key$", mo_Tools.SQLStr(as_key), , , vbTextCompare)
      mta_XmlSql(ll_Idx).Cursor = mo_Tools.OpenSQLSafe(ao_Db, ls_Request)
      Call mo_Db.Next(lc_Cursor)
      ll_Idx = ll_Idx + 1
    Wend
  Else
    Err.Raise ArmErr.SQLBadRowExpectedCount, "Distinct", "No SQL Data for XML export found."
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("InitSqlData")
End Sub

Private Sub CloseSqlData(ByVal ao_Db As Object)
On Error GoTo ErrorHandler

Dim ll_Idx As Long

  For ll_Idx = 0 To UBound(mta_XmlSql)
    Call ao_Db.Close(mta_XmlSql(ll_Idx).Cursor)
  Next
  ReDim mta_XmlSql(-1 To -1)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("CloseSqlData")
End Sub

Private Function GetXmlSql(ByVal al_ATS_Id As Long) As TXmlSql
On Error GoTo ErrorHandler

Dim ll_Idx As Long
  
  For ll_Idx = 0 To UBound(mta_XmlSql)
    If al_ATS_Id = mta_XmlSql(ll_Idx).ATS_Id Then
      GetXmlSql = mta_XmlSql(ll_Idx)
      Exit Function
    End If
  Next
  Exit Function
ErrorHandler:
  Call ErrorHandler("GetXmlSql")
End Function

Private Function GetXmlMasterSql() As TXmlSql
On Error GoTo ErrorHandler

Dim ll_Idx As Long
  
  For ll_Idx = 0 To UBound(mta_XmlSql)
    If mta_XmlSql(ll_Idx).ATS_IsMaster Then
      GetXmlMasterSql = mta_XmlSql(ll_Idx)
      Exit Function
    End If
  Next
  Exit Function
ErrorHandler:
  Call ErrorHandler("GetXmlMasterSql")
End Function

Private Function FormatXMLDateTime(ByVal ad_Value As Date) As String
On Error GoTo ErrorHandler
  
  FormatXMLDateTime = Format(ad_Value, "mm\/dd\/yyyy hh:mm:ss")
  Exit Function
ErrorHandler:
  Call ErrorHandler("FormatXMLDateTime")
End Function

Private Function FormatXMLFloat(ByVal ad_Value As Double, ByVal al_Precision As Long) As String
On Error GoTo ErrorHandler

  If al_Precision = 0 Then
    FormatXMLFloat = Format(Round(ad_Value, al_Precision), "0")
  Else
    FormatXMLFloat = Replace(Format(Round(ad_Value, al_Precision), "0." & String(al_Precision, "0")), ".", ",", , , vbTextCompare)
  End If
  Exit Function
ErrorHandler:
  Call ErrorHandler("FormatXMLFloat")
End Function

Private Function FormatXMLInt(ByVal al_Value As Long) As String
On Error GoTo ErrorHandler
  
  FormatXMLInt = CStr(al_Value)
  Exit Function
ErrorHandler:
  Call ErrorHandler("FormatXMLInt")
End Function

Private Function AppendElement(ByRef ao_Document As MSXML2.DOMDocument, ByRef ao_parentNode As MSXML2.IXMLDOMNode, ByVal as_Name As String, ByVal as_Value As String) As MSXML2.IXMLDOMNode
On Error GoTo ErrorHandler
    
   Set AppendElement = Nothing
    
#If LIVE = 1 Then
    Dim lo_newNode As Object
#Else
    Dim lo_newNode As MSXML2.IXMLDOMElement
#End If
    Set lo_newNode = ao_Document.createElement(as_Name)
    
    lo_newNode.Text = as_Value
    If ao_parentNode Is Nothing Then
      Set AppendElement = ao_Document.appendChild(lo_newNode)
    Else
      Set AppendElement = ao_parentNode.appendChild(lo_newNode)
    End If
    Exit Function
ErrorHandler:
    Call ErrorHandler("AppendElement")
End Function

Public Sub ImportArticleAll()
On Error GoTo ErrorHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim ll_RowIdTran As Long
Dim ls_Result As String
Dim le_Status As Long

  ls_req = "exec DPC_BaeurerPrd_lst $PRD_Id$,$PMaster_Status$,$SBox_Status$"
  ls_req = Replace(ls_req, "$PRD_Id$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$PMaster_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esExported), , vbTextCompare)
  ls_req = Replace(ls_req, "$SBox_Status$", "NULL", , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    ll_RowIdTran = mo_Db.GetFields(lc_Cursor, "PMaster_Rowidtran")
    ls_Result = CheckArticleExportResult(ll_RowIdTran)
    
    le_Status = eDPCBaeurerExportStatus.esNone
    If StrComp(ls_Result, ROWIDTRANSTATUS_ERROR, vbTextCompare) = 0 Then
      le_Status = eDPCBaeurerExportStatus.esExportFailed
    ElseIf StrComp(ls_Result, ROWIDTRANSTATUS_ERROR, vbTextCompare) = 0 Then
      le_Status = eDPCBaeurerExportStatus.esExportOK
    End If
    
    If le_Status <> eDPCBaeurerExportStatus.esNone Then
      ls_req = "UPDATE DPC_PrdBaeurer SET "
      ls_req = ls_req & "PMaster_Status=$PMaster_Status$,"
      ls_req = ls_req & "PMaster_Date=getdate(),"
      ls_req = ls_req & "Z_Last_Upd_User=$Z_Last_Upd_User$,"
      ls_req = ls_req & "Z_Last_Upd=getdate(),"
      ls_req = ls_req & "WHERE PRD_Id=$PRD_Id$"
      ls_req = Replace(ls_req, "$PRD_Id$", "NULL", , , vbTextCompare)
      ls_req = Replace(ls_req, "$PMaster_Status$", mo_Tools.SqlInt(le_Status), , vbTextCompare)
      Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
    End If
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("ImportArticleAll")
End Sub

Public Sub ExportArticleAll()
On Error GoTo ErrorHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim ll_RowIdTran As Long

  ls_req = "exec DPC_BaeurerPrd_lst $PRD_Id$,$PMaster_Status$,$SBox_Status$"
  ls_req = Replace(ls_req, "$PRD_Id$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$PMaster_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esReadyToExport), , vbTextCompare)
  ls_req = Replace(ls_req, "$SBox_Status$", "NULL", , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    ll_RowIdTran = ExportArticle(mo_Db.GetFields(mo_Db, "PRD_Id"))
    
    ls_req = "UPDATE DPC_PrdBaeurer SET "
    ls_req = ls_req & "PMaster_Status=$PMaster_Status$,"
    ls_req = ls_req & "PMaster_Date=getdate(),"
    ls_req = ls_req & "PMaster_Rowidtran=$Rowidtran$,"
    ls_req = ls_req & "Z_Last_Upd_User=$Z_Last_Upd_User$,"
    ls_req = ls_req & "Z_Last_Upd=getdate(),"
    ls_req = ls_req & "WHERE PRD_Id=$PRD_Id$"
    ls_req = Replace(ls_req, "$PRD_Id$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$PMaster_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esExported), , vbTextCompare)
    ls_req = Replace(ls_req, "$Rowidtran$", mo_Tools.SqlInt(ll_RowIdTran), , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("ExportArticleAll")
End Sub

Public Function ExportBOMMaterial(ByVal as_PRD_Id As String) As Boolean
On Error GoTo ErrorHandler

Dim lo_DPC_Product As DPC_Product
Dim lo_BOM As DPC_BOM

  ExportBOMMaterial = False
  Set lo_DPC_Product = New DPC_Product
  Set lo_DPC_Product.Tools = mo_Tools
  Set lo_DPC_Product.ArmDb = mo_Db
  lo_DPC_Product.U_Code = ml_U_Code
  lo_DPC_Product.CT_Code = ms_CT_Code
  lo_DPC_Product.CURR_Code = "EUR"
  lo_DPC_Product.ValidityDate = ValidityDate
  lo_DPC_Product.Language_Code = ms_Language_Code
  Call lo_DPC_Product.Load_A_COM
  Call lo_DPC_Product.Load(as_PRD_Id)
  Call lo_DPC_Product.LoadBOM
  For Each lo_BOM In lo_DPC_Product.BOMs
    If (StrComp(lo_BOM.BOM_IdentNr, DPC_BOM_NEW_IDENTNR, vbTextCompare) = 0) And (lo_BOM.BOM_IdentNrTmp <> "") Then
      If lo_BOM.BOM_Categ = eDPCBOMMaterial.bcCoil Then
        If ExportCoil(lo_DPC_Product, lo_BOM) Then
          lo_DPC_Product.COI_Code = lo_BOM.BOM_IdentNr
          Call lo_DPC_Product.UpdatePrdRectPanel
          Call lo_DPC_Product.UpdateBOMExport(lo_BOM)
        Else
          Exit Function
        End If
      ElseIf lo_BOM.BOM_Categ = eDPCBOMMaterial.bcInlay Then
        If ExportInlay(lo_DPC_Product, lo_BOM) Then
          Call lo_DPC_Product.UpdateBOMExport(lo_BOM)
        Else
          Exit Function
        End If
      Else
        Exit Function
      End If
    End If
  Next
  Call lo_DPC_Product.Unload_A_COM
  Set lo_DPC_Product = Nothing
  ExportBOMMaterial = True
  Exit Function
ErrorHandler:
  Call ErrorHandler("ExportBOMMaterial")
End Function


Public Function ExportCoil(ByVal ao_DPC_Product As DPC_Product, ByVal ao_BOM As DPC_BOM) As Boolean
On Error GoTo ErrorHandler

Dim lo_XmlDocCoil As Object
Dim ll_RowIdTran As Long
Dim lc_Cursor As Long
Dim ll_VersionCoil As Long
Dim ls_req As String
Dim ls_ThickPrefix As String
Dim ls_IdentPrefix As String
Dim ls_IdentNr As String
Dim ls_IdentNrTmp As String
Dim le_RawMaterial As eDPCBOMMaterial
Dim ls_Material As String
Dim ls_MaterialName As String
Dim lo_CustomData As Dictionary

  ExportCoil = False
  
  ls_IdentNr = ""
  ls_IdentNrTmp = ao_BOM.BOM_IdentNrTmp
  ls_IdentPrefix = Left(ao_BOM.BOM_IdentNrTmp, 2)
  
  le_RawMaterial = eDPCBOMMaterial.bcCoil
  ls_Material = ao_DPC_Product.RPL_MatTyp
  ls_MaterialName = "Spaltband " & mo_Tools.DblToScreen(ao_DPC_Product.RPL_CoilW) & " x " & mo_Tools.DblToScreen(ao_DPC_Product.RPL_Thick)
  
  ls_req = "exec DPC_Bae_Material_sel $IdentNr$,$BMN_Type$,$BMN_Prefix$,$BMN_Mat$,$BMN_Length$,$BMN_Width$,$BMN_Height$,$BMN_Thick$"
  ls_req = Replace(ls_req, "$IdentNr$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(le_RawMaterial), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Prefix$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Mat$", mo_Tools.SQLStr(ls_Material), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Length$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Width$", mo_Tools.SqlDbl(ao_DPC_Product.RPL_CoilW), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Height$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Thick$", mo_Tools.SqlDbl(ao_DPC_Product.RPL_Thick), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ls_IdentNr = mo_Tools.SelectValue(mo_Db, ls_req, "IdentNr")
    ls_MaterialName = mo_Tools.SelectValue(mo_Db, ls_req, "BMN_Name")
    ls_Material = mo_Tools.SelectValue(mo_Db, ls_req, "BMN_Mat")
  End If
  Call mo_Db.Close(lc_Cursor)
  
  If ls_IdentNr <> "" Then
    ao_BOM.BOM_IdentNr = ls_IdentNr
    ao_BOM.BOM_Name = ls_MaterialName
    ao_BOM.BOM_Material = ls_Material
    ExportCoil = True
    Exit Function
  End If
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
'  ls_req = "SELECT TOP 1 g000.IdentNr "
'  ls_req = ls_req & "FROM g000 "
'  ls_req = ls_req & "LEFT JOIN g040 ON (g000.fi_nr = g040.fi_nr AND g000.identnr = g040.identnr ) "
'  ls_req = ls_req & "LEFT JOIN g0402 ON (g000.fi_nr = g0402.fi_nr AND g000.identnr = g0402.identnr and g0402.lang_ext ='de_de') "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Width ON (g000.objektid = g711Width.objektid and g711Width.kritnr = 12) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Thick ON (g000.objektid = g711Thick.objektid and g711Thick.kritnr = 17) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711SpecWeight ON (g000.objektid = g711SpecWeight.objektid and g711SpecWeight.kritnr = 20) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Waste ON (g000.objektid = g711Waste.objektid and g711Waste.kritnr = 54) "
'  ls_req = ls_req & "LEFT JOIN g020 ON (g000.identnr = g020.identnr) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711StdCoil ON (g000.objektid = g711StdCoil.objektid and g711StdCoil.kritnr = 1181) "
'  ls_req = ls_req & "LEFT JOIN g023 ON (g000.fi_nr = g023.fi_nr AND g000.identnr = g023.identnr) "
'  ls_req = ls_req & "LEFT JOIN g030 on (g000.identnr = g030.identnr AND g000.fi_nr = g030.fi_nr) "
'  ls_req = ls_req & "WHERE "
'  ls_req = ls_req & "(g000.identnr LIKE $MAT_Pefx$) AND "
'  ls_req = ls_req & "(g0402.werkstoff = $MAT_Werk$) AND "
'  ls_req = ls_req & "(g040.ts = $ts$) AND "
'  ls_req = ls_req & "(g020.lgnr = $lgnr$) "
'
'  ls_req = Replace(ls_req, "$MAT_Pefx$", mo_Tools.SQLStr(as_IdentPrefix & "%"), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$ts$", mo_Tools.SQLStr(1), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$lgnr$", mo_Tools.SqlInt(0), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$MAT_Werk$", mo_Tools.SQLStr(as_Material), , , vbTextCompare)
'
'
'  lc_Cursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
'  ls_Key = mo_DbBaeurer.GetFields(lc_Cursor, 0)
'  Call mo_DbBaeurer.Close(lc_Cursor)
  
  ls_req = "SELECT MAX(g000.identnr) "
  ls_req = ls_req & "FROM g000 "
  ls_req = ls_req & "WHERE "
  ls_req = ls_req & "(g000.identnr LIKE $MAT_Pefx$) AND (LEN(g000.identnr) = $lenght$)"
  
'  ls_req = "SELECT MAX(g000.identnr) as IdentNr "
'  ls_req = ls_req & "FROM g000 "
'  ls_req = ls_req & "LEFT JOIN g040 ON (g000.fi_nr = g040.fi_nr AND g000.identnr = g040.identnr ) "
'  ls_req = ls_req & "LEFT JOIN g0402 ON (g000.fi_nr = g0402.fi_nr AND g000.identnr = g0402.identnr and g0402.lang_ext ='de_de') "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Width ON (g000.objektid = g711Width.objektid and g711Width.kritnr = 12) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Thick ON (g000.objektid = g711Thick.objektid and g711Thick.kritnr = 17) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711SpecWeight ON (g000.objektid = g711SpecWeight.objektid and g711SpecWeight.kritnr = 20) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Waste ON (g000.objektid = g711Waste.objektid and g711Waste.kritnr = 54) "
'  ls_req = ls_req & "LEFT JOIN g020 ON (g000.identnr = g020.identnr) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711StdCoil ON (g000.objektid = g711StdCoil.objektid and g711StdCoil.kritnr = 1181) "
'  ls_req = ls_req & "LEFT JOIN g023 ON (g000.fi_nr = g023.fi_nr AND g000.identnr = g023.identnr) "
'  ls_req = ls_req & "LEFT JOIN g030 on (g000.identnr = g030.identnr AND g000.fi_nr = g030.fi_nr) "
'  ls_req = ls_req & "WHERE "
'  ls_req = ls_req & "((g000.identnr LIKE $MAT_Pefx$) AND (LEN(g000.identnr) = $lenght$)) AND "
'  ls_req = ls_req & "(g0402.werkstoff = $MAT_Werk$ OR $MAT_Werk$ IS NULL) AND "
'  ls_req = ls_req & "(g040.ts = $ts$) AND "
'  ls_req = ls_req & "(g020.lgnr = $lgnr$) "
  
  
  ls_ThickPrefix = Trim(Str(ao_DPC_Product.RPL_Thick))
  If Left(ls_ThickPrefix, 1) = "." Then ls_ThickPrefix = "0" & ls_ThickPrefix
  ls_ThickPrefix = Replace(ls_ThickPrefix, ".", "")
  
  ls_req = Replace(ls_req, "$MAT_Pefx$", mo_Tools.SQLStr(ls_IdentPrefix & ls_ThickPrefix & "%"), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$ts$", mo_Tools.SQLStr(1), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$lgnr$", mo_Tools.SqlInt(0), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$MAT_Werk$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$lenght$", mo_Tools.SqlInt(Len(ls_IdentPrefix & ls_ThickPrefix) + 4), , , vbTextCompare)
  
  ls_IdentNr = mo_Tools.SelectValue(mo_DbBaeurer, ls_req)
  
  Do
    If ls_IdentNr = "" Then
      ls_IdentNr = ls_IdentPrefix & ls_ThickPrefix & "0001"
    Else
      If right(ls_IdentNr, 4) = "9999" Then
        Call MsgBox("Counter IdentNr for coil prefix: " & ls_IdentPrefix & ls_ThickPrefix & " overflow")
        Exit Function
      Else
        ls_IdentNr = ls_IdentPrefix & ls_ThickPrefix & (right("0000" & Val(right(ls_IdentNr, 4)) + 1, 4))
      End If
    End If
    'check if we recently did not use this identnr for another coil, need to create new identr by incrementing
    ls_req = "exec DPC_Bae_Material_sel $IdentNr$, $BMN_Type$, $BMN_Prefix$, $BMN_Mat$, $BMN_Length$, $BMN_Width$, $BMN_Height$, $BMN_Thick$"
    ls_req = Replace(ls_req, "$IdentNr$", mo_Tools.SQLStr(ls_IdentNr), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcCoil), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Prefix$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Mat$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Length$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Width$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Height$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Thick$", "NULL", , , vbTextCompare)
  Loop Until mo_Tools.SelectValue(mo_Db, ls_req, "IdentNr") = ""
  
  Set lo_CustomData = New Dictionary
  Call lo_CustomData.Add("$identnr$", ls_IdentNr)
  Call lo_CustomData.Add("$ben$", ls_MaterialName)
  Call lo_CustomData.Add("$werkstoff$", ls_Material)
  Call lo_CustomData.Add("$breiteb$", ao_DPC_Product.RPL_CoilW)
  Call lo_CustomData.Add("$matdicke$", ao_DPC_Product.RPL_Thick)
  Call lo_CustomData.Add("$stlidentnr$", ls_IdentNr)
  Call lo_CustomData.Add("$aplidentnr$", ls_IdentNr)
  Call lo_CustomData.Add("$vpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$orpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$invpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$datvon$", ao_BOM.BOM_DatVon)
  Call lo_CustomData.Add("$menge_ab$", ao_BOM.BOM_Menge_Ab)
  Set lo_XmlDocCoil = CreateXMLDocument(mo_DbBaeurer, eDPCXmlExportType.etMaterial, ls_IdentNrTmp, ll_VersionCoil, lo_CustomData)
  
#If TEST = 0 Then
  'Call SaveXMLDocument(lo_XmlDocCoil, "PMASTER")
  'Exit Function
#End If
  
  ll_RowIdTran = ExportPMasterRecord(mo_DbBaeurer, 0, ls_IdentNr, eDPCXmlExportType.etMaterial, lo_XmlDocCoil, ll_VersionCoil)
  Call ExportPMasterComplete(mo_DbBaeurer, ll_RowIdTran, ls_IdentNr)
  'insert exported ident nr into our historical table
  ls_req = "exec DPC_Bae_Material_ins $IdentNr$,$BMN_Name$,$BMN_Type$,$BMN_Prefix$,$BMN_Mat$,$BMN_Length$,$BMN_Width$,$BMN_Height$,$BMN_Thick$, $U_Code$"
  ls_req = Replace(ls_req, "$IdentNr$", mo_Tools.SQLStr(ls_IdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Name$", mo_Tools.SQLStr(ls_MaterialName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcCoil), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Prefix$", mo_Tools.SQLStr(ls_IdentPrefix), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Mat$", mo_Tools.SQLStr(ls_Material), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Length$", "0", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Width$", mo_Tools.SqlDbl(ao_DPC_Product.RPL_CoilW), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Height$", "0", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Thick$", mo_Tools.SqlDbl(ao_DPC_Product.RPL_Thick), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  
  ao_BOM.BOM_IdentNr = ls_IdentNr
  ao_BOM.BOM_Name = ls_MaterialName
  ao_BOM.BOM_Material = ls_Material
  
  Call lo_CustomData.RemoveAll
  Set lo_CustomData = Nothing
  ExportCoil = True
  Exit Function
ErrorHandler:
  Call ErrorHandler("ExportCoil")
End Function

Public Function ExportInlay(ByVal ao_DPC_Product As DPC_Product, ByVal ao_BOM As DPC_BOM) As Boolean
On Error GoTo ErrorHandler

Dim lo_XmlDocInlay As Object
Dim ll_RowIdTran As Long
Dim lc_Cursor As Long
Dim ll_VersionInlay As Long
Dim ls_req As String
Dim ls_IdentNr As String
Dim ls_IdentPrefix As String
Dim ls_IdentNrTmp As String
Dim le_RawMaterial As eDPCBOMMaterial
Dim ls_Material As String
Dim ls_MaterialName As String
Dim lo_CustomData As Dictionary
Dim ls_UoM_PCS As String

  ExportInlay = False
  
  ls_IdentNr = ""
  ls_IdentNrTmp = ao_BOM.BOM_IdentNrTmp
  ls_IdentPrefix = "3EX"
  
  le_RawMaterial = eDPCBOMMaterial.bcInlay
  ls_MaterialName = "Akustikvlieszuschnitt " & mo_Tools.DblToScreen(ao_BOM.BOM_CutLength, 1) & "x" & mo_Tools.DblToScreen(ao_BOM.BOM_CutWidth, 1) & " mm"
  ls_Material = ao_BOM.BOM_Material
  
  ls_req = "exec DPC_Bae_Material_sel $IdentNr$,$BMN_Type$,$BMN_Prefix$,$BMN_Mat$,$BMN_Length$,$BMN_Width$,$BMN_Height$,$BMN_Thick$"
  ls_req = Replace(ls_req, "$IdentNr$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcInlay), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Prefix$", mo_Tools.SQLStr(ls_IdentPrefix), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Mat$", mo_Tools.SQLStr(ls_IdentNrTmp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Length$", mo_Tools.SqlDbl(ao_BOM.BOM_CutLength), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Width$", mo_Tools.SqlDbl(ao_BOM.BOM_CutWidth), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Height$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Thick$", "NULL", , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ls_IdentNr = mo_Tools.SelectValue(mo_Db, ls_req, "IdentNr")
    ls_MaterialName = mo_Tools.SelectValue(mo_Db, ls_req, "BMN_Name")
    ls_Material = mo_Tools.SelectValue(mo_Db, ls_req, "BMN_Mat")
  End If
  Call mo_Db.Close(lc_Cursor)

  If ls_IdentNr <> "" Then
    ao_BOM.BOM_IdentNr = ls_IdentNr
    ao_BOM.BOM_Name = ls_MaterialName
    ao_BOM.BOM_Material = ls_Material
    ExportInlay = True
    Exit Function
  End If
  
  
  ls_req = "SELECT MAX(g000.identnr) "
  ls_req = ls_req & "FROM g000 "
  ls_req = ls_req & "WHERE "
  ls_req = ls_req & "(g000.identnr LIKE $MAT_Pefx$) AND (LEN(g000.identnr) = $lenght$)"
  
  ls_req = Replace(ls_req, "$MAT_Pefx$", mo_Tools.SQLStr(ls_IdentPrefix & "%"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$lenght$", mo_Tools.SqlInt(Len(ls_IdentPrefix) + 4), , , vbTextCompare)
  
  ls_IdentNr = mo_Tools.SelectValue(mo_DbBaeurer, ls_req)
  
  Do
    If ls_IdentNr = "" Then
      ls_IdentNr = ls_IdentPrefix & "0001"
    Else
      If right(ls_IdentNr, 4) = "9999" Then
        Call MsgBox("Counter IdentNr for inlay prefix: " & ls_IdentPrefix & " overflow")
        Exit Function
      Else
        ls_IdentNr = ls_IdentPrefix & (right("0000" & Val(right(ls_IdentNr, 4)) + 1, 4))
      End If
    End If
    'check if we recently did not use this identnr for another coil, need to create new identr by incrementing
    ls_req = "exec DPC_Bae_Material_sel $IdentNr$, $BMN_Type$, $BMN_Prefix$, $BMN_Mat$, $BMN_Length$, $BMN_Width$, $BMN_Height$, $BMN_Thick$"
    ls_req = Replace(ls_req, "$IdentNr$", mo_Tools.SQLStr(ls_IdentNr), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcInlay), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Prefix$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Mat$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Length$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Width$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Height$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Thick$", "NULL", , , vbTextCompare)
  Loop Until mo_Tools.SelectValue(mo_Db, ls_req, "IdentNr") = ""
  
  
  Set lo_CustomData = New Dictionary
  ls_UoM_PCS = mo_Tools.ConvertCodeToBaeurer(mo_Db, eDPCCodeConversionBaeurer.ccUnitOfMeasure, DPC_UOM_PCS)
  Call lo_CustomData.Add("$identnr$", ls_IdentNr)
  Call lo_CustomData.Add("$ben$", ls_MaterialName)
  Call lo_CustomData.Add("$werkstoff$", ls_Material)
  Call lo_CustomData.Add("$laengea$", ao_BOM.BOM_CutLength)
  Call lo_CustomData.Add("$breiteb$", ao_BOM.BOM_CutWidth)
  Call lo_CustomData.Add("$me$", ls_UoM_PCS)
  Call lo_CustomData.Add("$mes$", ls_UoM_PCS)
  Call lo_CustomData.Add("$stlidentnr$", ls_IdentNr)
  Call lo_CustomData.Add("$aplidentnr$", ls_IdentNr)
  Call lo_CustomData.Add("$qm$", (ao_BOM.BOM_CutLength * ao_BOM.BOM_CutWidth) / 1000000)
  Call lo_CustomData.Add("$vpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$orpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$invpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$datvon$", ao_BOM.BOM_DatVon)
  Call lo_CustomData.Add("$menge_ab$", ao_BOM.BOM_Menge_Ab)
  
  Set lo_XmlDocInlay = CreateXMLDocument(mo_DbBaeurer, eDPCXmlExportType.etMaterial, ls_IdentNrTmp, ll_VersionInlay, lo_CustomData)
  
#If TEST = 0 Then
  'Call SaveXMLDocument(lo_XmlDocInlay, "PMASTER")
  'Exit Function
#End If
  
  ll_RowIdTran = ExportPMasterRecord(mo_DbBaeurer, 0, ls_IdentNr, eDPCXmlExportType.etMaterial, lo_XmlDocInlay, ll_VersionInlay)
  Call ExportPMasterComplete(mo_DbBaeurer, ll_RowIdTran, ls_IdentNr)
  'insert exported ident nr into our historical table
  ls_req = "exec DPC_Bae_Material_ins $IdentNr$,$BMN_Name$,$BMN_Type$,$BMN_Prefix$,$BMN_Mat$,$BMN_Length$,$BMN_Width$,$BMN_Height$,$BMN_Thick$, $U_Code$"
  ls_req = Replace(ls_req, "$IdentNr$", mo_Tools.SQLStr(ls_IdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Name$", mo_Tools.SQLStr(ls_MaterialName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcInlay), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Prefix$", mo_Tools.SQLStr(ls_IdentPrefix), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Mat$", mo_Tools.SQLStr(ls_IdentNrTmp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Length$", mo_Tools.SqlDbl(ao_BOM.BOM_CutLength), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Width$", mo_Tools.SqlDbl(ao_BOM.BOM_CutWidth), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Height$", "0", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Thick$", "0", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  
  ao_BOM.BOM_IdentNr = ls_IdentNr
  ao_BOM.BOM_Name = ls_MaterialName
  ao_BOM.BOM_Material = ls_Material
  
  Call lo_CustomData.RemoveAll
  Set lo_CustomData = Nothing
  
  ExportInlay = True
  Exit Function
ErrorHandler:
  Call ErrorHandler("ExportInlay")
End Function

Public Function ExportArticle(ByVal as_PRD_Id As String) As Long
On Error GoTo ErrorHandler

Dim lo_XmlDocPMaster As Object
Dim lo_XmlDocBOM As Object
Dim lo_XmlDocBOR As Object
Dim ll_RowIdTran As Long
Dim ls_PRD_Code As String
Dim ls_Request As String
Dim lc_Cursor As Long
Dim ll_VersionPMaster As Long
Dim ll_VersionBOM As Long
Dim ll_VersionBOR As Long

  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
  If Not ExportBOMMaterial(as_PRD_Id) Then
    Exit Function
  End If
  
  Set lo_XmlDocPMaster = CreateXMLDocument(mo_Db, eDPCXmlExportType.etArticleMaster, as_PRD_Id, ll_VersionPMaster, Nothing)
  Set lo_XmlDocBOM = CreateXMLDocument(mo_Db, eDPCXmlExportType.etBOM, as_PRD_Id, ll_VersionBOM, Nothing)
  Set lo_XmlDocBOR = CreateXMLDocument(mo_Db, eDPCXmlExportType.etBOR, as_PRD_Id, ll_VersionBOR, Nothing)
  
#If TEST = 0 Then
  'Call SaveXMLDocument(lo_XmlDocPMaster, "PMASTER")
  'Call SaveXMLDocument(lo_XmlDocBOM, "BOM")
  'Call SaveXMLDocument(lo_XmlDocBOR, "BOR")
#End If

  ls_Request = "SELECT PRD_Code FROM DPC_PrdCommon WHERE PRD_Id=$PRD_Id$"
  ls_Request = Replace(ls_Request, "$PRD_Id$", mo_Tools.SQLStr(as_PRD_Id), , , vbTextCompare)
  ls_PRD_Code = mo_Tools.SelectValue(mo_Db, ls_Request)
  
  ll_RowIdTran = ExportPMasterRecord(mo_DbBaeurer, 0, ls_PRD_Code, eDPCXmlExportType.etArticleMaster, lo_XmlDocPMaster, ll_VersionPMaster)
  Call ExportPMasterRecord(mo_DbBaeurer, ll_RowIdTran, ls_PRD_Code, eDPCXmlExportType.etBOM, lo_XmlDocBOM, ll_VersionBOM)
  Call ExportPMasterRecord(mo_DbBaeurer, ll_RowIdTran, ls_PRD_Code, eDPCXmlExportType.etBOR, lo_XmlDocBOR, ll_VersionBOR)
  Call ExportPMasterComplete(mo_DbBaeurer, ll_RowIdTran, as_PRD_Id)
  ExportArticle = ll_RowIdTran
  Exit Function
ErrorHandler:
  Call ErrorHandler("ExportArticle")
End Function

Public Sub ExportXml(ByVal ll_RowId As Long)
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Sub
  End If
  Call mo_DbBaeurer.BlobToFileSQL("SELECT xmllong from tran_sc where rowid=" & ll_RowId, "c:\xml\test.xml")
End Sub

Private Function CheckArticleExportResult(ByVal al_RowIdTran As Long) As String
On Error GoTo ErrorHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim lc_FilterError As Long
Dim ll_CountError As Long
Dim lc_FilterOK As Long
Dim ll_CountOK As Long

  CheckArticleExportResult = ""
  ls_req = "SELECT status_tran FROM tran_sc WHERE rowidtran=$rowidtran$"
  ls_req = Replace(ls_req, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  If mo_DbBaeurer.RowCount(lc_Cursor) = 3 Then
  
    lc_FilterError = mo_DbBaeurer.Filter(lc_Cursor, "status_tran", "=", ROWIDTRANSTATUS_ERROR, 1)
    ll_CountError = mo_DbBaeurer.RowCount(lc_FilterError)
    Call mo_DbBaeurer.Close(lc_FilterError)
    
    lc_FilterOK = mo_DbBaeurer.Filter(lc_Cursor, "status_tran", "=", ROWIDTRANSTATUS_OK, 1)
    ll_CountOK = mo_DbBaeurer.RowCount(lc_FilterOK)
    Call mo_DbBaeurer.Close(lc_FilterOK)
    
    If ll_CountError > 0 Then
      CheckArticleExportResult = ROWIDTRANSTATUS_ERROR
    ElseIf ll_CountOK = 3 Then
      CheckArticleExportResult = ROWIDTRANSTATUS_OK
    End If
  End If
  Call mo_DbBaeurer.Close(lc_Cursor)
  Exit Function
ErrorHandler:
  Call ErrorHandler("CheckArticleExportResult")
End Function

Private Function CheckCustomerExportResult(ByVal al_RowIdTran As Long) As String
On Error GoTo ErrorHandler

Dim ls_req As String
Dim lc_Cursor As Long

  CheckCustomerExportResult = ""
  ls_req = "SELECT status_tran FROM tran_cus WHERE rowidtran=$rowidtran$"
  ls_req = Replace(ls_req, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  If mo_DbBaeurer.RowCount(lc_Cursor) = 1 Then
  
    If StrComp(mo_DbBaeurer.GetFields(lc_Cursor, "status_tran"), ROWIDTRANSTATUS_ERROR, vbTextCompare) = 0 Then
      CheckCustomerExportResult = ROWIDTRANSTATUS_ERROR
    ElseIf StrComp(mo_DbBaeurer.GetFields(lc_Cursor, "status_tran"), ROWIDTRANSTATUS_OK, vbTextCompare) = 0 Then
      CheckCustomerExportResult = ROWIDTRANSTATUS_OK
    End If
  End If
  Call mo_DbBaeurer.Close(lc_Cursor)
  Exit Function
ErrorHandler:
  Call ErrorHandler("CheckCustomerExportResult")
End Function

Private Function CreateBaeurerConnection(ByVal ao_Db As Object) As Long
On Error GoTo ErrorHandler

Dim ll_ConnectId As Long
Dim ls_req As String

  ls_req = "INSERT INTO b050 "
  ls_req = ls_req & "(connect_id ,logname, tty, datuhr, gruppe, session_id, logname_os, serverapp)"
  ls_req = ls_req & " VALUES "
  ls_req = ls_req & "($connect_id$ ,$logname$, $tty$, getdate(), $gruppe$, @@SPID, $logname_os$, $serverapp$)"
  
  ls_req = Replace(ls_req, "$connect_id$", mo_Tools.SqlInt(DPC_DEFUALT_BAEURER_CONNECTID), , , vbTextCompare)
  ls_req = Replace(ls_req, "$logname$", mo_Tools.SQLStr(ms_BaeurerLoginName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$tty$", mo_Tools.SQLStr(ms_PC_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$gruppe$", mo_Tools.SQLStr("badmin"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$session_id$", mo_Tools.SqlInt(DPC_DEFUALT_BAEURER_CONNECTID), , , vbTextCompare)
  ls_req = Replace(ls_req, "$logname_os$", mo_Tools.SQLStr(ms_BaeurerLoginName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$serverapp$", mo_Tools.SQLStr(ms_BaeurerServer), , , vbTextCompare)
  
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req)
  CreateBaeurerConnection = DPC_DEFUALT_BAEURER_CONNECTID
  Exit Function
ErrorHandler:
  Call ErrorHandler("CreateBaeurerConnection")
End Function

Private Function CloseBaeurerConnection(ByVal ao_Db As Object, ByVal al_Connect_Id As Long) As Boolean
On Error GoTo ErrorHandler

Dim ls_req As String
  
  ls_req = "DELETE FROM b050 WHERE connect_id=$connect_id$"
  ls_req = Replace(ls_req, "$connect_id$", mo_Tools.SqlInt(al_Connect_Id), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req)
  Exit Function
ErrorHandler:
  Call ErrorHandler("CloseBaeurerConnection")
End Function

Private Function LockRecord(ByVal ao_Db As Object, ByVal as_Table As String, ByVal av_Key As Variant, as_Screen As String) As Long
On Error GoTo ErrorHandler

Dim ls_req As String
Dim ls_Key As String

  LockRecord = 0
  If IsArray(av_Key) Then
    ls_Key = Join(av_Key, "@")
  Else
    ls_Key = Str(av_Key)
  End If
 
  Call CloseBaeurerConnection(mo_DbBaeurer, DPC_DEFUALT_BAEURER_CONNECTID)
  ml_BaeurerConnectID = CreateBaeurerConnection(ao_Db)
  If ml_BaeurerConnectID = 0 Then
    Exit Function
  End If
  
  ls_req = "SELECT COUNT(*) FROM b030 WHERE schluessel=$schluessel$"
  ls_req = Replace(ls_req, "$schluessel$", mo_Tools.SQLStr(ls_Key), , , vbTextCompare)
  If mo_Tools.SelectValue(ao_Db, ls_req) > 0 Then
    Call CloseBaeurerConnection(ao_Db, ml_BaeurerConnectID)
    ml_BaeurerConnectID = 0
    Exit Function
  End If

  ls_req = "INSERT INTO [b030] "
  ls_req = ls_req & "([tabelle] ,[fi_nr], [schluessel], [logname], [connect_id], [maske], [datuhr]) "
  ls_req = ls_req & " VALUES "
  ls_req = ls_req & "($tabelle$ ,$fi_nr$, $schluessel$, $logname$, $connect_id$, $maske$, getdate())"
  
  ls_req = Replace(ls_req, "$tabelle$", mo_Tools.SQLStr(as_Table), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$schluessel$", mo_Tools.SQLStr(ls_Key), , , vbTextCompare)
  ls_req = Replace(ls_req, "$logname$", mo_Tools.SQLStr(ms_BaeurerSource), , , vbTextCompare)
  ls_req = Replace(ls_req, "$maske$", mo_Tools.SQLStr(as_Screen), , , vbTextCompare)
  ls_req = Replace(ls_req, "$connect_id$", mo_Tools.SqlInt(ml_BaeurerConnectID), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req, 1)
  
  LockRecord = mo_Tools.GetLastIdentity(ao_Db)
  Exit Function
ErrorHandler:
  'do nothing, lock was not succesfull it will be shown in the message
End Function

Private Sub UnlockRecord(ByVal ao_Db As Object, ByVal al_RowId As Long)
On Error GoTo ErrorHandler
  
Dim ls_Request As String
  
  ls_Request = "DELETE FROM [b030] WHERE rowid=$rowid$"
  ls_Request = Replace(ls_Request, "$rowid$", mo_Tools.SqlInt(al_RowId), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
  Call CloseBaeurerConnection(mo_DbBaeurer, ml_BaeurerConnectID)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("UnlockRecord")
End Sub

Private Function CreateNextIdOfferPos(ByVal ao_Collection As Collection)
On Error GoTo ErrorHandler

Dim ls_OFD_IdParNew As String
Dim lo_Offer As DPC_OfferPos
  
  ls_OFD_IdParNew = mo_Tools.GetNextID(mo_Db, "Cap_OfferDetail")
  For Each lo_Offer In ao_Collection
    If lo_Offer.OFD_Main = eDPCOfferDetailMain.odMain Then
      lo_Offer.OFD_Id = ls_OFD_IdParNew
      lo_Offer.OFD_IdPar = ls_OFD_IdParNew
    Else
      lo_Offer.OFD_Id = mo_Tools.GetNextID(mo_Db, "Cap_OfferDetail")
      lo_Offer.OFD_IdPar = ls_OFD_IdParNew
    End If
  Next
  Exit Function
ErrorHandler:
  Call ErrorHandler("CreateNextIdOfferPos")
End Function

Private Function CopyOfferPos(ByVal as_COF_Id As String, ByVal as_OFD_Id As String, ByVal al_SplitNr As Long, ByRef al_OFD_PosSrc As Long) As String
On Error GoTo ErrorHandler

Dim ls_req As String
Dim ls_OFD_IdParNew As String
Dim lo_Offer As DPC_OfferPos
Dim lo_Collection As Collection
Dim ls_Request As String
Dim lc_Cursor As Long

  Set lo_Collection = New Collection
  
  ls_Request = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Main$", "NULL", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_IdPar$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Valid$", "NULL", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Id$", "NULL", , , vbTextCompare)
  ls_Request = ReplaceCommonPlaceholders(ls_Request)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  While Not mo_Db.EOF(lc_Cursor)
    Set lo_Offer = New DPC_OfferPos
    Set lo_Offer.Tools = mo_Tools
    Call lo_Offer.ReadOfferPos(mo_Db, lc_Cursor)
    Call lo_Collection.Add(lo_Offer)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  
  ls_OFD_IdParNew = mo_Tools.GetNextID(mo_Db, "Cap_OfferDetail")
  For Each lo_Offer In lo_Collection
    lo_Offer.OFD_IdPar = ls_OFD_IdParNew
    lo_Offer.OFD_Pos = lo_Offer.OFD_Pos + (al_SplitNr * 10)
    If (lo_Offer.DOF_Id = eDPCOfferDetail.odPosition) Or _
       (lo_Offer.DOF_Id = eDPCOfferDetail.odSubconstPosition) Or _
       (lo_Offer.DOF_Id = eDPCOfferDetail.odManualPosition) Then
      lo_Offer.OFD_Id = ls_OFD_IdParNew
      al_OFD_PosSrc = lo_Offer.OFD_Pos
    Else
      lo_Offer.OFD_Id = mo_Tools.GetNextID(mo_Db, "Cap_OfferDetail")
    End If
    Call lo_Offer.Insert(mo_Db, ml_U_Code)
  Next
  CopyOfferPos = ls_OFD_IdParNew
  Exit Function
ErrorHandler:
  Call ErrorHandler("CopyOfferPos")
End Function

Private Sub UpdateOrderPositionFromPlaningBox(ByVal as_COF_Id As String, ByVal as_OFD_Id As String, ByVal al_OFD_Split As Long, ByVal ac_PlanBoxCursor As Long)
On Error GoTo ErrorHandler

Dim lo_Product As DPC_Product
Dim lo_Offer As DPC_OfferPos
Dim lo_Cutout As DPC_Cutout
Dim lo_Inlay As DPC_Inlay
Dim ls_PRD_Id As String
Dim ls_req As String
Dim ll_QtyPCS As Long

  ls_req = "SELECT PRD_Id FROM Cap_OfferDetail WHERE COF_Id=$COF_Id$ AND OFD_Id=$OFD_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  ls_PRD_Id = mo_Tools.SelectValue(mo_Db, ls_req)
  
  If ls_PRD_Id = "" Then
    Err.Raise ArmErr.InvalidArgument, "ls_PRD_Id", "Article ID not found: as_COF_Id=" & as_COF_Id & " as_OFD_Id=" & as_OFD_Id
  End If
  
  Set lo_Product = New DPC_Product
  Set lo_Product.Tools = mo_Tools
  Set lo_Product.ArmDb = mo_Db
  lo_Product.CT_Code = ms_CT_Code
  lo_Product.ValidityDate = ValidityDate
  lo_Product.Language_Code = ms_Language_Code
  lo_Product.COF_Id = as_COF_Id
  lo_Product.U_Code = ml_U_Code
  Call lo_Product.Load_A_COM
  Call lo_Product.InitOffer
  Call lo_Product.Load(ls_PRD_Id)
  Call lo_Product.LoadOffer(as_COF_Id, as_OFD_Id)
    
  ll_QtyPCS = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "menge_best")
  If lo_Product.PanelQtyPCS <> ll_QtyPCS Then
    For Each lo_Offer In lo_Product.OfferPrice
      If (Not lo_Offer.DOF_IsStp) And (Not lo_Offer.DOF_IsTxt) Then
        Call lo_Offer.SetQty(DPC_UOM_PCS, ll_QtyPCS)
        Call lo_Offer.Update(mo_Db, ml_U_Code)
      End If
    Next
    For Each lo_Cutout In lo_Product.Cutouts
      For Each lo_Offer In lo_Cutout.OfferPrice
        If (Not lo_Offer.DOF_IsStp) And (Not lo_Offer.DOF_IsTxt) Then
          Call lo_Offer.SetQty(DPC_UOM_PCS, ll_QtyPCS)
          Call lo_Offer.Update(mo_Db, ml_U_Code)
        End If
      Next
    Next
    For Each lo_Inlay In lo_Product.Inlays
      For Each lo_Offer In lo_Inlay.OfferPrice
        If (Not lo_Offer.DOF_IsStp) And (Not lo_Offer.DOF_IsTxt) Then
          Call lo_Offer.SetQty(DPC_UOM_PCS, ll_QtyPCS)
          Call lo_Offer.Update(mo_Db, ml_U_Code)
        End If
      Next
    Next
    Call lo_Product.CalcPositionPrice
  End If
    
  Set lo_Offer = lo_Product.GetOfferPos(eDPCOfferDetail.odPosition)
  lo_Offer.OFD_ShpDat = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "lief_termb")
  lo_Offer.OFD_PlaDat = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "dataen")
  lo_Offer.OFD_PlaUsr = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "useraen")
  lo_Offer.OFD_B7Sta = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "kn_verarb")
  lo_Offer.OFD_Split = al_OFD_Split
  lo_Offer.OFD_InfoB7 = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "info_b7")
  lo_Offer.OFD_OrdNrB7 = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "aufnr")
  lo_Offer.OFD_PosB7 = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "aufpos")
  Call lo_Offer.Update(mo_Db, ml_U_Code)
  Call lo_Product.Unload_A_COM
  Set lo_Product = Nothing
  Exit Sub
ErrorHandler:
  Call ErrorHandler("UpdateOrderPositionFromPlaningBox")
End Sub

Private Sub UpdatePlaningBoxFromOrderPosition(ByVal as_COF_Code As String, ByVal al_OFD_Pos As Long, ByVal al_OFD_Split As Long, ByVal al_OFD_PosSrc As Long)
On Error GoTo ErrorHandler

Dim ls_req As String
  ', kn_verarb=$kn_verarb_new$  - changed, status will be changed after XML export to SAP/B7
  ls_req = "UPDATE va1101 SET seblpos_q=$aufpos_q_new$, aufpos_q=$aufpos_q_new$ WHERE aufnr_q=$aufnr_q$ AND aufpos_q=$aufpos_q_old$ AND seblpos=$seblpos$ AND fi_nr=$fi_nr$ AND kn_verarb=$kn_verarb_old$"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufpos_q_old$", mo_Tools.SqlInt(al_OFD_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufpos_q_new$", mo_Tools.SqlInt(al_OFD_PosSrc), , , vbTextCompare)
  ls_req = Replace(ls_req, "$seblpos$", mo_Tools.SqlInt(al_OFD_Split), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SQLStr(BAE_PLABOX_RequestReadyForCapture), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestAcceptedByCapture), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("UpdatePlaningBoxFromOrderPosition")
End Sub

Public Sub UpdatePlaningBoxStatus(ByVal as_COF_Code As String, ByVal as_kn_verarb_old As String, ByVal as_kn_verarb_new As String)
On Error GoTo ErrorHandler

Dim ls_req As String
Dim ll_LockRowId As Long

  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Sub
  End If
  
  ll_LockRowId = LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, as_COF_Code), "vva100")
  If ll_LockRowId = 0 Then
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 666, "#Manufacturing validation in progress")
    Exit Sub
  End If
  
  ls_req = "UPDATE va1101 SET kn_verarb=$kn_verarb_new$ WHERE aufnr_q=$aufnr_q$ AND fi_nr=$fi_nr$ AND kn_verarb IN ($kn_verarb_old$)"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(as_kn_verarb_old), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(as_kn_verarb_new), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
  
  Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Call mo_DbBaeurer.Disconnect
  Exit Sub
ErrorHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrorHandler("UpdatePlaningBoxStatus")
End Sub

Public Function CheckExistCustPurchOrderNumber(ByVal as_COF_CodeCus As String, ByVal al_Konto As Long) As Boolean
On Error GoTo ErrorHandler

Dim ls_req As String
Dim ll_LockRowId As Long

  CheckExistCustPurchOrderNumber = True
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
  ls_req = "SELECT best_nr from v100 where konto = $konto$ and vvorgart = '1' and fi_nr = $fi_nr$ and best_nr = $COF_CodeCus$"
  ls_req = Replace(ls_req, "$konto$", mo_Tools.SqlInt(al_Konto), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COF_CodeCus$", mo_Tools.SQLStr(as_COF_CodeCus), , , vbTextCompare)
  CheckExistCustPurchOrderNumber = mo_Tools.SelectValue(mo_DbBaeurer, ls_req) <> ""
  Call mo_DbBaeurer.Disconnect
  Exit Function
ErrorHandler:
  Call ErrorHandler("CheckExistCustPurchOrderNumber")
End Function

Private Function FindOrderPositionLink(ByVal as_COF_Id As String, ByVal al_OFD_Pos As Long, ByVal as_PRD_Code As String, ByVal al_OFD_Split As Long) As String
On Error GoTo ErrorHandler

Dim ls_req As String
  
  ls_req = "SELECT TOP 1 OFD_IdPar FROM Cap_OfferDetail WHERE COF_Id=$COF_Id$ AND OFD_Pos=$OFD_Pos$ AND OFD_Main=$OFD_Main$ AND PRD_Code=$PRD_Code$ AND ISNULL(OFD_Split,0)=$OFD_Split$ AND Drop_Flag=''"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Pos$", mo_Tools.SqlInt(al_OFD_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", mo_Tools.SqlInt(eDPCOfferDetailMain.odMain), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(as_PRD_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Split$", mo_Tools.SqlInt(al_OFD_Split), , , vbTextCompare)
  FindOrderPositionLink = mo_Tools.SelectValue(mo_Db, ls_req)
  Exit Function
ErrorHandler:
  Call ErrorHandler("FindOrderPositionLink")
End Function

Public Function AcceptPlanningBox(ByVal as_COF_Id As String, ByVal as_COF_Code As String, ByRef as_ErrMsg As String) As Boolean
On Error GoTo ErrorHandler

Dim ls_req As String
Dim lc_PlanBoxCursor As Long
Dim ls_OFD_Id As String, ls_OFD_IdSrc As String
Dim ll_OFD_Pos As Long, ll_OFD_PosSrc As Long
Dim ls_PRD_Code As String, ls_COF_Code As String
Dim ll_OFD_Split As Long
Dim ll_ConnectId As Long
Dim ll_LockRowId As Long
  
  as_ErrMsg = ""
  AcceptPlanningBox = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
  ll_LockRowId = LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, as_COF_Code), "vva100")
  If ll_LockRowId = 0 Then
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 666, "#Manufacturing validation in progress")
    Exit Function
  End If
  
  ls_req = "SELECT * FROM va1101 WHERE (aufnr_q=$aufnr_q$) AND (fi_nr=$fi_nr$) AND (kn_verarb IN ($kn_verarb$)) ORDER BY aufnr_q, aufpos_q, seblpos"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestDeadlineTimeout)), , , vbTextCompare)
  lc_PlanBoxCursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  
  If mo_DbBaeurer.RowCount(lc_PlanBoxCursor) = 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_Db.Close(lc_PlanBoxCursor)
    as_ErrMsg = "No item is approved in planning box"
    Exit Function
  End If
  
  If mo_DbBaeurer.Find(lc_PlanBoxCursor, "kn_verarb", BAE_PLABOX_RequestDeadlineTimeout) >= 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_Db.Close(lc_PlanBoxCursor)
    as_ErrMsg = "Request deadline timeout"
    Exit Function
  Else
  
    Call mo_DbBaeurer.First(lc_PlanBoxCursor)
    While Not mo_DbBaeurer.EOF(lc_PlanBoxCursor)
      ls_COF_Code = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufnr_q")
      ll_OFD_Pos = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufpos_q")
      ll_OFD_PosSrc = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "seblpos_q")
      ls_PRD_Code = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "identnr")
      ll_OFD_Split = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "seblpos")
      ls_OFD_Id = ""
      ' find source order line position - original order line exported to planning box which may or may not be splitted
      ls_OFD_IdSrc = FindOrderPositionLink(as_COF_Id, ll_OFD_Pos, ls_PRD_Code, 0)
      ' update link of capture order line into planning box and change status as it was imported ok by Capture
      Call UpdatePlaningBoxFromOrderPosition(ls_COF_Code, ll_OFD_Pos, ll_OFD_Split, ll_OFD_PosSrc)
      ' go to next planning box line
      Call mo_DbBaeurer.Next(lc_PlanBoxCursor)
    Wend
    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
  End If
  Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Call mo_DbBaeurer.Disconnect
  AcceptPlanningBox = True
  Exit Function
ErrorHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrorHandler("ImportSecretBox")
End Function

Public Function ImportSecretBox(ByVal as_COF_Id As String, ByVal as_COF_Code As String, ByRef as_ErrMsg As String) As Boolean
On Error GoTo ErrorHandler

Dim ls_req As String
Dim lc_PlanBoxCursor As Long
Dim ls_OFD_Id As String, ls_OFD_IdSrc As String
Dim ll_OFD_Pos As Long, ll_OFD_PosSrc As Long
Dim ls_PRD_Code As String, ls_COF_Code As String
Dim ll_OFD_Split As Long
Dim ll_SplitNr As Long
Dim ll_LockRowId As Long
Dim ls_COF_CodeBae As String

  as_ErrMsg = ""
  ImportSecretBox = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
  ll_LockRowId = LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, as_COF_Code), "vva100")
  If ll_LockRowId = 0 Then
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 666, "#Manufacturing validation in progress")
    Exit Function
  End If
  
  ls_req = "SELECT * FROM va1101 WHERE (aufnr_q=$aufnr_q$) AND (fi_nr=$fi_nr$) AND (kn_verarb IN ($kn_verarb$)) ORDER BY aufnr_q, aufpos_q, seblpos"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestDeadlineTimeout)), , , vbTextCompare)
  lc_PlanBoxCursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  
  If mo_DbBaeurer.RowCount(lc_PlanBoxCursor) = 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
    as_ErrMsg = "No item is approved in planning box"
    Exit Function
  End If
  
  If mo_DbBaeurer.Find(lc_PlanBoxCursor, "kn_verarb", BAE_PLABOX_RequestDeadlineTimeout) >= 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
    as_ErrMsg = "Request deadline timeout"
    Exit Function
  Else
    ls_COF_CodeBae = ""
    Call mo_DbBaeurer.First(lc_PlanBoxCursor)
    While Not mo_DbBaeurer.EOF(lc_PlanBoxCursor)
      ls_COF_Code = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufnr_q")
      ll_OFD_Pos = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufpos_q")
      ll_OFD_PosSrc = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "seblpos_q")
      ls_PRD_Code = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "identnr")
      ll_OFD_Split = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "seblpos")
      ls_OFD_Id = ""
      If (ls_COF_CodeBae = "") And (mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufnr") <> "") Then
        ls_COF_CodeBae = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufnr")
      End If
      ' find source order line position - original order line exported to planning box which may or may not be splitted
      ls_OFD_IdSrc = FindOrderPositionLink(as_COF_Id, ll_OFD_Pos, ls_PRD_Code, 0)
      If ls_OFD_IdSrc = "" Then
        Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
        Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
        ' we did not found line in capture order
        as_ErrMsg = "Order line not found for article: " & ls_PRD_Code & " position: " & ll_OFD_Pos & " block: " & ll_OFD_Split
        Exit Function
      End If
      
      ' calculate real split "position offset" - if line is split, copied line will get new position number with offset to original line position number
      If ll_OFD_Split = 0 Then
        ll_SplitNr = 0
        ls_OFD_Id = ls_OFD_IdSrc
      Else
        ' we have some split, increment position counter (maybe we can user ll_OFD_Split, but is it consistent?)
        ll_SplitNr = ll_SplitNr + 1
        ' in case we try to import the same order from planning box again - line is marked and linked to existing order line
        If ll_OFD_PosSrc > 0 Then
          ls_OFD_Id = FindOrderPositionLink(as_COF_Id, ll_OFD_PosSrc, ls_PRD_Code, ll_OFD_Split)
          ' link exist, but line not found in Capture.. hmm create it again or how error ?
          If (ls_OFD_Id = "") Then
            ls_OFD_Id = CopyOfferPos(as_COF_Id, ls_OFD_IdSrc, ll_SplitNr, ll_OFD_PosSrc)
          End If
        Else
          ' in case we detected split and dont have link in planing box, copy base offer description
          ls_OFD_Id = CopyOfferPos(as_COF_Id, ls_OFD_IdSrc, ll_SplitNr, ll_OFD_PosSrc)
        End If
      End If
      
      If ls_OFD_Id = "" Then
        Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
        Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
        as_ErrMsg = "Order line not found for article: " & ls_PRD_Code & " position: " & ll_OFD_Pos & " block: " & ll_OFD_Split
        Exit Function
      End If
      ' update qty, shipment date and other attributes from planning box into capture order line position
      Call UpdateOrderPositionFromPlaningBox(as_COF_Id, ls_OFD_Id, ll_OFD_Split, lc_PlanBoxCursor)
      ' update link of capture order line into planning box and change status as it was imported ok by Capture
      Call UpdatePlaningBoxFromOrderPosition(ls_COF_Code, ll_OFD_Pos, ll_OFD_Split, ll_OFD_PosSrc)
      ' go to next planning box line
      Call mo_DbBaeurer.Next(lc_PlanBoxCursor)
    Wend
    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
  End If
  
  If ls_COF_CodeBae <> "" Then
    ls_req = "UPDATE Cap_Offer SET COF_CodeBae=$COF_CodeBae$ WHERE COF_Id=$COF_Id$"
    ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
    ls_req = Replace(ls_req, "$COF_CodeBae$", mo_Tools.SQLStr(ls_COF_CodeBae), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  End If
  
  Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Call mo_DbBaeurer.Disconnect
  ImportSecretBox = True
  Exit Function
ErrorHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrorHandler("ImportSecretBox")
End Function


Public Function KillSecretBox(ByVal as_COF_Id As String, ByVal as_COF_Code As String, ByRef as_ErrMsg As String) As Boolean
On Error GoTo ErrorHandler

Dim ls_req As String
Dim lc_PlanBoxCursor As Long
Dim ll_LockRowId As Long
Dim lc_Status As Long
Dim ls_KN_Verarb_Old As String
Dim ls_KN_Verarb_New As String

  as_ErrMsg = ""
  KillSecretBox = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
  ll_LockRowId = LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, as_COF_Code), "vva100")
  If ll_LockRowId = 0 Then
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 666, "#Manufacturing validation in progress")
    Exit Function
  End If
  
  ls_req = "SELECT * FROM va1101 WHERE (aufnr_q=$aufnr_q$) AND (fi_nr=$fi_nr$) AND (kn_verarb IN ($kn_verarb$)) ORDER BY aufnr_q, aufpos_q, seblpos"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_FromCaptureReady, BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestInProgress, BAE_PLABOX_RequestDeadlineTimeout)), , , vbTextCompare)
  lc_PlanBoxCursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  
  If mo_DbBaeurer.RowCount(lc_PlanBoxCursor) = 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
    as_ErrMsg = "No item to kill in planning box"
    Exit Function
  End If
  
  lc_Status = mo_DbBaeurer.Distinct(lc_PlanBoxCursor, "kn_verarb")
  If mo_DbBaeurer.RowCount(lc_Status) > 1 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Close(lc_Status)
    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
    as_ErrMsg = "No item to kill in planning box"
    Exit Function
  End If
  ls_KN_Verarb_Old = mo_DbBaeurer.GetFields(lc_Status, "kn_verarb")
  Call mo_DbBaeurer.Close(lc_Status)
  
  If StrComp(ls_KN_Verarb_Old, BAE_PLABOX_FromCaptureReady, vbTextCompare) = 0 Then
    ls_KN_Verarb_New = BAE_PLABOX_RequestConfirmationMarkedDelete
  ElseIf StrComp(ls_KN_Verarb_Old, BAE_PLABOX_RequestReadyForCapture, vbTextCompare) = 0 Then
    ls_KN_Verarb_New = BAE_PLABOX_RequestConfirmationMarkedDelete
  Else
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
    as_ErrMsg = "You cannot delete planning box items with status: " & ls_KN_Verarb_Old
    Exit Function
  End If
  
  'Call UpdatePlaningBoxStatus(as_COF_Code, ls_KN_Verarb_Old, ls_KN_Verarb_New)
  ls_req = "UPDATE va1101 SET kn_verarb=$kn_verarb_new$ WHERE aufnr_q=$aufnr_q$ AND fi_nr=$fi_nr$ AND kn_verarb IN ($kn_verarb_old$)"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(ls_KN_Verarb_Old), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(ls_KN_Verarb_New), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
  
  ls_req = "UPDATE Cap_Offer SET COF_CodeBae='' WHERE COF_Id=$COF_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  
  ls_req = "UPDATE Cap_OfferDetail SET OFD_OrdNrB7='', OFD_PosB7=0, OFD_InfoB7='' WHERE COF_Id=$COF_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  
  
  Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Call mo_DbBaeurer.Disconnect
  KillSecretBox = True
  Exit Function
ErrorHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrorHandler("KillSecretBox")
End Function

Public Function GetOrderType(ByVal ao_Db As Object, ByVal al_Konto As Long) As Long
On Error GoTo ErrorHandler

Dim ls_req As String

  ls_req = "SELECT auf_art FROM g600 WHERE fi_nr=$fi_nr$ AND satzart=$satzart$ AND konto=$konto$"
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$satzart$", mo_Tools.SqlInt(1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$konto$", mo_Tools.SqlInt(al_Konto), , , vbTextCompare)
  GetOrderType = mo_Tools.SelectValue(ao_Db, ls_req)
  Exit Function
ErrorHandler:
  Call ErrorHandler("ImportSecretBox")
End Function

Public Function GetUserAccount(ByVal ao_Db As Object, ByVal al_Konto As Long, ByVal as_Email As String) As Long
On Error GoTo ErrorHandler

Dim ls_req As String

'  ls_req = "SELECT sb_schl FROM g915 WHERE fi_nr=$fi_nr$ AND email=$email$"
'  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$email$", mo_Tools.SQLStr(as_Email), , , vbTextCompare)
  ls_req = "SELECT ansprnr FROM g620 WHERE fi_nr=$fi_nr$ AND satzart=$satzart$ AND konto=$konto$ AND email=$email$"
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$satzart$", mo_Tools.SqlInt(1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$konto$", mo_Tools.SqlInt(al_Konto), , , vbTextCompare)
  ls_req = Replace(ls_req, "$email$", mo_Tools.SQLStr(as_Email), , , vbTextCompare)
  GetUserAccount = mo_Tools.SelectValue(ao_Db, ls_req)
  Exit Function
ErrorHandler:
  Call ErrorHandler("GetUserAccount")
End Function

Public Sub InsertProductSecretBox(ByVal ao_Db As Object, ByVal ac_Offer As Long, ByVal ac_OfferPos As Long)
On Error GoTo ErrorHandler

Dim ls_req As String
  
  ls_req = "INSERT INTO [va1101] "
  ls_req = ls_req & "([abrmenge], [aendnr], [identnr], [var], [aufnr_q], [aufpos_q], [auf_dat], [best_dat], [datbis], [lief_prio],"
  ls_req = ls_req & "[dataen], [datneu], [wunsch_term], [fi_nr], [kn_abruf], [sb_schl_q], [kn_verarb], [useraen], [userneu], [status_menge],"
  ls_req = ls_req & "[status_termin], [status_ruestko], [lief_termb], [menge_best], [sb_schl], [datum_frei], [konto], [satzart], [auf_art],"
  ls_req = ls_req & "[ben], [mevk], [projekt_id], [vvorgart], [lgnr], [info_b7], [aufnr], [aufpos], [ruestko], [info_txt], [info_b7_k],"
  ls_req = ls_req & "[seblpos], [seblpos_q], [kn_rueko], [vers_art], [lb]) "
  ls_req = ls_req & "VALUES"
  ls_req = ls_req & "($abrmenge$, $aendnr$, $identnr$, $var$, $aufnr_q$, $aufpos_q$, $auf_dat$, $best_dat$, $datbis$, $lief_prio$,"
  ls_req = ls_req & "$dataen$, $datneu$, $wunsch_term$, $fi_nr$, $kn_abruf$, $sb_schl_q$, $kn_verarb$, $useraen$, $userneu$, $status_menge$,"
  ls_req = ls_req & "$status_termin$, $status_ruestko$, $lief_termb$, $menge_best$, $sb_schl$, $datum_frei$, $konto$, $satzart$, $auf_art$,"
  ls_req = ls_req & "$ben$, $mevk$, $projekt_id$, $vvorgart$, $lgnr$, $info_b7$, $aufnr$, $aufpos$, $ruestko$, $info_txt$, $info_b7_k$,"
  ls_req = ls_req & "$seblpos$, $seblpos_q$, $kn_rueko$, $vers_art$, $lb$) "

  ls_req = Replace(ls_req, "$abrmenge$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_QtyPCS")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aendnr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$identnr$", mo_Tools.SQLStr(mo_Db.GetFields(ac_OfferPos, "PRD_Code")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$var$", mo_Tools.SQLStr(" "), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(Left(mo_Db.GetFields(ac_Offer, "COF_Code"), 10)), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufpos_q$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_Pos")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$auf_dat$", mo_Tools.SqlDate(mo_Db.GetFields(ac_Offer, "Z_Creation")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$best_dat$", mo_Tools.SqlDate(mo_Db.GetFields(ac_Offer, "Z_Creation")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$datbis$", mo_Tools.SqlDate(mo_Db.GetFields(ac_Offer, "COF_ExDat")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$lief_prio$", mo_Tools.SQLStr("5"), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$dataen$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$datneu$", "getdate()", , , vbTextCompare)
  ls_req = Replace(ls_req, "$wunsch_term$", mo_Tools.SqlDate(mo_Db.GetFields(ac_OfferPos, "OFD_WshDat")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_abruf$", "NULL", , , vbTextCompare)
  'ls_Req = Replace(ls_Req, "$sb_schl_q$", mo_Tools.SqlInt(GetUserAccount(ao_Db, mo_Db.GetFields(ac_Offer, "LEN_BaeKonto"), mo_Db.GetFields(ac_Offer, "Z_CreatorEmail"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$sb_schl_q$", mo_Tools.SqlInt(Val(mo_Db.GetFields(ac_Offer, "COF_Bae_Partner"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SQLStr(BAE_PLABOX_FromCaptureReady), , , vbTextCompare)
  ls_req = Replace(ls_req, "$useraen$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$userneu$", mo_Tools.SQLStr(mo_Db.GetFields(ac_Offer, "Z_CreatorDesc")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$status_menge$", "NULL", , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$status_termin$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$status_ruestko$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$lief_termb$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$menge_best$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$sb_schl$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$datum_frei$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$konto$", mo_Tools.SqlInt(Val(mo_Db.GetFields(ac_Offer, "LEN_BaeKonto"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$satzart$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$auf_art$", mo_Tools.SqlInt(GetOrderType(ao_Db, mo_Db.GetFields(ac_Offer, "LEN_BaeKonto"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$ben$", mo_Tools.SQLStr(Left(mo_Db.GetFields(ac_Offer, "SP_Desc"), 40)), , , vbTextCompare)
  ls_req = Replace(ls_req, "$mevk$", mo_Tools.SQLStr("STK"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$projekt_id$", mo_Tools.SQLStr(mo_Db.GetFields(ac_Offer, "SP_Capkey")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$vvorgart$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$lgnr$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$info_b7$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufnr$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufpos$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$ruestko$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$info_txt$", mo_Tools.SQLStr(mo_Db.GetFields(ac_Offer, "COF_Comm"), 70), , , vbTextCompare)
  ls_req = Replace(ls_req, "$info_b7_k$", "NULL", , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$seblpos$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$seblpos_q$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_Pos")), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$kn_rueko$", "NULL", , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$vers_art$", mo_Tools.SqlInt(Val(mo_Db.GetFields(ac_Offer, "COF_Bae_DelType"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$lb$", mo_Tools.SqlInt(Val(mo_Db.GetFields(ac_Offer, "COF_Bae_DelCond"))), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req, 1)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("InsertProductSecretBox")
End Sub

Public Function ExportSecretBox(ByVal as_COF_Id As String, ByRef as_ErrMessage As String) As Boolean
On Error GoTo ErrorHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim ll_LockRowId As Long
Dim lc_Offer As Long
Dim lc_OfferPos As Long
Dim ll_CAT_Id As Long
Dim le_DOF_Id As eDPCOfferDetail
Dim le_OFD_Main As eDPCOfferDetailMain
Dim lc_PlanBoxCursor As Long
Dim ls_Status As String
Dim lb_PlanningFinished As Boolean
Dim lb_PlanningNotStarted As Boolean
Dim lb_PlanningTimeout As Boolean

  ExportSecretBox = False
  as_ErrMessage = ""
  
'  ls_req = "SELECT CCU.CCU_B7Konto FROM Cap_Offer COF INNER JOIN claim_customer CCU ON (COF.CCU_CapKey=CCU.CCU_Capkey) WHERE COF.COF_Id =$COF_Id$"
'  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
'  If mo_Tools.SelectValue(mo_Db, ls_req) = 0 Then
'    as_ErrMessage = "#Offer customer was not exported to Baeurer B7"
'    Exit Function
'  End If
  
  
  ls_req = "SELECT COUNT(*) FROM Cap_OfferDetail OFD INNER JOIN DPC_PrdCommon PRD ON (OFD.PRD_Id=PRD.PRD_Id) WHERE OFD.COF_Id =$COF_Id$ AND OFD.OFD_Main=1 AND OFD.OFD_Valid='X' AND (OFD.DOF_Id IN (1)) AND (OFD.CAT_Id IN (1)) AND PRD.PRD_StaBae<>1 AND OFD.Drop_Flag=''"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  If mo_Tools.SelectValue(mo_Db, ls_req) > 0 Then
    as_ErrMessage = "#Not all custom materials inside sales order were successfuly exported to Baeurer B7"
    Exit Function
  End If
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
  ls_req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  lc_Offer = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  ls_req = "SELECT LEN.LEN_BaeKonto FROM GEN_LegalEntity LEN WHERE LEN.LEN_Id = $LEN_Id$"
  ls_req = Replace(ls_req, "$LEN_Id$", mo_Tools.SqlInt(mo_Db.GetFields(lc_Offer, "LEN_Id")), , , vbTextCompare)
  If Trim(mo_Tools.SelectValue(mo_Db, ls_req)) = "" Then
    Call mo_Db.Close(lc_Offer)
    Call mo_Db.Close(lc_OfferPos)
    as_ErrMessage = "#Internal customer is not defined for selected legal entity"
    Exit Function
  End If
  
  ls_req = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_IdPar$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Valid$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", "NULL", , , vbTextCompare)
  lc_OfferPos = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  ll_LockRowId = LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, mo_Db.GetFields(lc_Offer, "COF_Code")), "vva100")
  If ll_LockRowId = 0 Then
    Call mo_Db.Close(lc_Offer)
    Call mo_Db.Close(lc_OfferPos)
    as_ErrMessage = "#Manufacturing validation in progress"
    Exit Function
  End If
  
  lb_PlanningFinished = False
  lb_PlanningNotStarted = False
  lb_PlanningTimeout = False
  ls_req = "SELECT kn_verarb FROM va1101 WHERE (aufnr_q=$aufnr_q$) AND (fi_nr=$fi_nr$) AND (kn_verarb NOT IN ($kn_verarb$)) ORDER BY aufnr_q, aufpos_q, seblpos"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(mo_Db.GetFields(lc_Offer, "COF_Code")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestConfirmationMarkedDelete, BAE_PLABOX_RequestConfirmationDeletedByBaeurer, BAE_PLABOX_RequestTrashed)), , , vbTextCompare)
  lc_PlanBoxCursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  If mo_DbBaeurer.RowCount(lc_PlanBoxCursor) > 0 Then
  
    Call mo_DbBaeurer.First(lc_PlanBoxCursor)
    While Not mo_DbBaeurer.EOF(lc_PlanBoxCursor)
      ls_Status = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "kn_verarb")
      If ls_Status = BAE_PLABOX_RequestReadyForCapture Then
        lb_PlanningFinished = True
        If lb_PlanningNotStarted Or lb_PlanningTimeout Then
          as_ErrMessage = "#Inconsistent state of planing box - status mixed: " & BAE_PLABOX_RequestReadyForCapture & BAE_PLABOX_FromCaptureReady & BAE_PLABOX_RequestInProgress & BAE_PLABOX_RequestDeadlineTimeout
          Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
          Call mo_Db.Close(lc_Offer)
          Call mo_Db.Close(lc_OfferPos)
          Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
          Exit Function
        End If
      ElseIf (ls_Status = BAE_PLABOX_FromCaptureReady) Or _
         (ls_Status = BAE_PLABOX_RequestInProgress) Then
        lb_PlanningNotStarted = True
        If lb_PlanningFinished Or lb_PlanningTimeout Then
          as_ErrMessage = "#Inconsistent state of planing box - status mixed: " & BAE_PLABOX_RequestReadyForCapture & BAE_PLABOX_FromCaptureReady & BAE_PLABOX_RequestInProgress & BAE_PLABOX_RequestDeadlineTimeout
          Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
          Call mo_Db.Close(lc_Offer)
          Call mo_Db.Close(lc_OfferPos)
          Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
          Exit Function
        End If
      ElseIf ls_Status = BAE_PLABOX_RequestDeadlineTimeout Then
        lb_PlanningTimeout = True
        If lb_PlanningFinished Or lb_PlanningNotStarted Then
          as_ErrMessage = "#Inconsistent state of planing box - status mixed: " & BAE_PLABOX_RequestReadyForCapture & BAE_PLABOX_FromCaptureReady & BAE_PLABOX_RequestInProgress & BAE_PLABOX_RequestDeadlineTimeout
          Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
          Call mo_Db.Close(lc_Offer)
          Call mo_Db.Close(lc_OfferPos)
          Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
          Exit Function
        End If
      Else
        as_ErrMessage = "#Order is locked in the planning box"
        Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
        Call mo_Db.Close(lc_Offer)
        Call mo_Db.Close(lc_OfferPos)
        Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
        Exit Function
      End If
      Call mo_DbBaeurer.Next(lc_PlanBoxCursor)
    Wend
  End If
  Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
  
  ls_req = "UPDATE va1101 SET kn_verarb=$kn_verarb_new$ WHERE aufnr_q=$aufnr_q$ AND fi_nr=$fi_nr$ AND kn_verarb IN ($kn_verarb_old$)"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(mo_Db.GetFields(lc_Offer, "COF_Code")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  If lb_PlanningFinished Then
    ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestConfirmationMarkedDelete), , , vbTextCompare)
    ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestReadyForCapture)), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
  ElseIf lb_PlanningNotStarted Then
    ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestConfirmationDeletedByBaeurer), , , vbTextCompare)
    ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_FromCaptureReady, BAE_PLABOX_RequestInProgress, BAE_PLABOX_RequestAcceptedByCapture)), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
  ElseIf lb_PlanningTimeout Then
    ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestConfirmationDeletedByBaeurer), , , vbTextCompare)
    ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestDeadlineTimeout)), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
  End If
  
  Call mo_Db.First(lc_OfferPos)
  While Not mo_Db.EOF(lc_OfferPos)
    le_OFD_Main = mo_Db.GetFields(lc_OfferPos, "OFD_Main")
    ll_CAT_Id = mo_Db.GetFields(lc_OfferPos, "CAT_Id")
    le_DOF_Id = mo_Db.GetFields(lc_OfferPos, "DOF_Id")
    If (le_OFD_Main = eDPCOfferDetailMain.odMain) And _
       (le_DOF_Id = eDPCOfferDetail.odPosition) And _
      ((ll_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) Or (ll_CAT_Id = eDPCCategory.cgMetalPanelSKU)) Then
      If mo_Db.GetFields(lc_OfferPos, "OFD_B7Sta") <> 7 Then
        Call InsertProductSecretBox(mo_DbBaeurer, lc_Offer, lc_OfferPos)
      End If
    End If
    Call mo_Db.Next(lc_OfferPos)
  Wend
  
  Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Call mo_Db.Close(lc_Offer)
  Call mo_Db.Close(lc_OfferPos)
  Call mo_DbBaeurer.Disconnect
  ExportSecretBox = True
  Exit Function
ErrorHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrorHandler("ExportSecretBox")
End Function

'Public Function ExportSecretBox(ByVal ac_Offer As Long, ByVal ac_OfferPos As Long) As Boolean
'On Error GoTo errorHandler
'
'Dim lo_Product As DPC_Product
'Dim ll_LockRowId As Long
'Dim lc_Offer As Long
'Dim lc_OfferPos As Long
'Dim lc_PlanBoxCursor As Long
'Dim ls_Req As String
'Dim ls_Status As String

    
'  ls_Req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
'  ls_Req = Replace(ls_Req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
'  lc_Offer = mo_Tools.OpenSQLSafe(mo_Db, ls_Req)
'
'  ls_Req = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
'  ls_Req = Replace(ls_Req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$OFD_Main$", "NULL", , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$OFD_IdPar$", "NULL", , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$OFD_Valid$", "NULL", , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
'  lc_OfferPos = mo_Tools.OpenSQLSafe(mo_Db, ls_Req, 1)
'
'  Set lo_Product = New DPC_Product
'  Set lo_Product.Tools = mo_Tools
'  Set lo_Product.ArmDb = mo_Db
'  lo_Product.U_Code = ml_U_Code
'  lo_Product.CT_Code = ms_CT_Code
'  lo_Product.CURR_Code = "EUR"
'  lo_Product.ValidityDate = ValidityDate
'  lo_Product.Language_Code = "E"
'  lo_Product.COF_Id = as_COF_Id
'  Call lo_Product.Load_A_COM
'  Call lo_Product.InitOffer
'  Call lo_Product.Load(mo_Db.GetFields(lc_OfferPos, "PRD_ID"))
'  Call lo_Product.LoadOffer(as_COF_Id, as_OFD_Id)
  
  'll_LockRowId = LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, mo_Db.GetFields(lc_Offer, "COF_Code")), "vva100")
'  Call InsertProductSecretBox(mo_DbBaeurer, ac_Offer, ac_OfferPos)
  'Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'  Call mo_Db.Close(lc_Offer)
'  Call mo_Db.Close(lc_OfferPos)
'  Call lo_Product.Unload_A_COM
'  Set lo_Product = Nothing
'  ExportSecretBox = True
'  Exit Function
'errorHandler:
'  Call errorHandler("ExportSecretBox")
'End Function

Public Sub ExportCustomerAll()
On Error GoTo ErrorHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim ll_RowIdTran As Long

  ls_req = "exec xxx_lst $PRD_Id$,$Cust_Status$"
  ls_req = Replace(ls_req, "$PRD_Id$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$Cust_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esReadyToExport), , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    ll_RowIdTran = ExportArticle(mo_Db.GetFields(mo_Db, "PRD_Id"))
    
    ls_req = "UPDATE xxxxx SET "
    ls_req = ls_req & "PMaster_Status=$PMaster_Status$,"
    ls_req = ls_req & "PMaster_Date=getdate(),"
    ls_req = ls_req & "PMaster_Rowidtran=$Rowidtran$,"
    ls_req = ls_req & "Z_Last_Upd_User=$Z_Last_Upd_User$,"
    ls_req = ls_req & "Z_Last_Upd=getdate(),"
    ls_req = ls_req & "WHERE PRD_Id=$PRD_Id$"
    ls_req = Replace(ls_req, "$PRD_Id$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$PMaster_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esExported), , vbTextCompare)
    ls_req = Replace(ls_req, "$Rowidtran$", mo_Tools.SqlInt(ll_RowIdTran), , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("ExportCustomerAll")
End Sub

Public Function ExportCustomer(ByVal as_CCU_Capkey As String) As Boolean
On Error GoTo ErrorHandler

Dim lo_XmlDocCust As Object
Dim ll_RowIdTran As Long
Dim ll_Konto As Long
Dim ls_Request As String
Dim lc_Cursor As Long
Dim ll_VersionCust As Long

  ExportCustomer = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If

  
#If TEST = 0 Then
  'Call SaveXMLDocument(lo_XmlDocCust, "CUST")
  'Exit Function
#End If
  
  ls_Request = "SELECT CCU_B7Konto FROM claim_customer WHERE CCU_Capkey=$CCU_Capkey$"
  ls_Request = Replace(ls_Request, "$CCU_Capkey$", mo_Tools.SQLStr(as_CCU_Capkey), , , vbTextCompare)
  ll_Konto = mo_Tools.SelectValue(mo_Db, ls_Request)
  
  If ll_Konto = 0 Then
    
    ls_Request = "SELECT MAX(Konto) + 1 FROM g600 where konto < 99999999 and fi_nr = 1"
    ll_Konto = mo_Tools.SelectValue(mo_DbBaeurer, ls_Request)
    
    ls_Request = "UPDATE claim_customer SET CCU_B7Konto=$CCU_B7Konto$ WHERE CCU_CapKey=$CCU_Capkey$"
    ls_Request = Replace(ls_Request, "$CCU_B7Konto$", mo_Tools.SqlInt(ll_Konto), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$CCU_Capkey$", mo_Tools.SQLStr(as_CCU_Capkey), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request, 1)
    
    Set lo_XmlDocCust = CreateXMLDocument(mo_Db, eDPCXmlExportType.etCustomer, as_CCU_Capkey, ll_VersionCust, Nothing)
    ll_RowIdTran = ExportCustomerRecord(mo_DbBaeurer, 0, ll_Konto, eDPCXmlExportType.etCustomer, lo_XmlDocCust, ll_VersionCust)
    Call ExportCustomerComplete(mo_DbBaeurer, ll_RowIdTran, as_CCU_Capkey)
    
    
    ExportCustomer = True
  End If
  Exit Function
ErrorHandler:
  Call ErrorHandler("ExportCustomer")
End Function

Private Function ExportPMasterRecord(ByVal ao_Db As Object, ByVal al_RowIdTran As Long, ByVal as_key As String, ByVal ae_ATR_Type As eDPCXmlExportType, ByRef ao_XMLDoc As MSXML2.DOMDocument, ByVal al_Version As Long) As Long
On Error GoTo ErrorHandler

Dim ls_Request As String
Dim ls_RequestTran As String
Dim ls_path As String
Dim ll_RowId As Long
Dim lc_Cursor As Long

  ls_Request = "INSERT INTO tran_sc " & _
              "(rowidtran,identnr,var,xmldatatype,xmllong,status_tran,msg_text,uebdat,verarbdat,versionsnr,source) " & _
              "VALUES " & _
              "($rowidtran$, $identnr$, $var$, $xmldatatype$, $xmllong$, $status_tran$, $msg_text$, $uebdat$, $verarbdat$, $versionsnr$, $source$)"
              
  ls_RequestTran = "UPDATE tran_sc SET rowidtran=rowid where rowid=$rowid$"
  
  ls_Request = Replace(ls_Request, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$status_tran$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$msg_text$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$uebdat$", "getdate()", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$verarbdat$", "NULL", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$versionsnr$", mo_Tools.SqlInt(al_Version), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$source$", mo_Tools.SQLStr(ms_BaeurerSource), , , vbTextCompare)
  
  ls_Request = Replace(ls_Request, "$identnr$", mo_Tools.SqlStrKey(as_key), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$var$", mo_Tools.SQLStr(""), , , vbTextCompare)
  
  Select Case ae_ATR_Type
  Case eDPCXmlExportType.etArticleMaster
    ls_path = CreateXMLPath("PMASTER", as_key)
    ls_Request = Replace(ls_Request, "$xmldatatype$", mo_Tools.SQLStr("PMASTER"), , , vbTextCompare)
  Case eDPCXmlExportType.etBOM
    ls_path = CreateXMLPath("BOM", as_key)
    ls_Request = Replace(ls_Request, "$xmldatatype$", mo_Tools.SQLStr("BOM"), , , vbTextCompare)
  Case eDPCXmlExportType.etBOR
    ls_path = CreateXMLPath("BOR", as_key)
    ls_Request = Replace(ls_Request, "$xmldatatype$", mo_Tools.SQLStr("BOR"), , , vbTextCompare)
  Case eDPCXmlExportType.etMaterial
    ls_path = CreateXMLPath("PMASTER", as_key)
    ls_Request = Replace(ls_Request, "$xmldatatype$", mo_Tools.SQLStr("PMASTER"), , , vbTextCompare)
  Case Else
    Err.Raise ArmErr.InvalidArgument, "ae_ATR_Type", "Invalid ATR_Type: " & ae_ATR_Type
  End Select
  
  ls_Request = Replace(ls_Request, "$xmllong$", mo_Tools.SQLStr(ao_XMLDoc.xml), , , vbTextCompare)
  
  
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
  ll_RowId = mo_Tools.GetLastIdentity(ao_Db)
 
  If al_RowIdTran = 0 Then
    ls_RequestTran = Replace(ls_RequestTran, "$rowid$", mo_Tools.SqlInt(ll_RowId), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_RequestTran)
  End If
  ExportPMasterRecord = ll_RowId
  Exit Function
ErrorHandler:
  Call ErrorHandler("ExportPMasterRecord")
End Function

Private Function ExportCustomerRecord(ByVal ao_Db As Object, ByVal al_RowIdTran As Long, ByVal al_Konto As Long, ByVal ae_ATR_Type As eDPCXmlExportType, ByRef ao_XMLDoc As MSXML2.DOMDocument, ByVal al_Version As Long) As Long
On Error GoTo ErrorHandler

Dim ls_Request As String
Dim ls_RequestTran As String
Dim ls_path As String
Dim ll_RowId As Long
Dim lc_Cursor As Long

  ls_Request = "INSERT INTO tran_cus (rowidtran, konto, satzart, xmldatatype, xmllong, status_tran, msg_text, uebdat, verarbdat, versionsnr, source) " & _
              " VALUES " & _
              "($rowidtran$, $konto$, $satzart$, $xmldatatype$, $xmllong$, $status_tran$, $msg_text$, $uebdat$, $verarbdat$, $versionsnr$, $source$)"
  ls_RequestTran = "UPDATE tran_cus SET rowidtran=rowid where rowid=$rowid$"
  
  ls_Request = Replace(ls_Request, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$status_tran$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$msg_text$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$uebdat$", "getdate()", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$verarbdat$", "NULL", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$versionsnr$", mo_Tools.SqlInt(al_Version), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$source$", mo_Tools.SQLStr(ms_BaeurerSource), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$konto$", mo_Tools.SqlIntKey(al_Konto), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$satzart$", mo_Tools.SqlInt(1), , , vbTextCompare)
  
  ls_path = CreateXMLPath("CUST", al_Konto)
  
  If ae_ATR_Type = eDPCXmlExportType.etCustomer Then
    ls_Request = Replace(ls_Request, "$xmldatatype$", mo_Tools.SQLStr("CUSTOMER"), , , vbTextCompare)
  Else
    Err.Raise ArmErr.InvalidArgument, "ae_ATR_Type", "Invalid ATR_Type: " & ae_ATR_Type
  End If
  
  ls_Request = Replace(ls_Request, "$xmllong$", mo_Tools.SQLStr(ao_XMLDoc.xml), , , vbTextCompare)
  Call ao_XMLDoc.Save(ls_path)
  
'  If Not ao_Db.FileToBlobSQL(ls_Request, ls_Path, 0, 0) Then
'    Err.Raise ArmErr.CompFncFailed, "FileToBlobSQL", ao_Db.LastErrorMessage
'  End If
  
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
  ll_RowId = mo_Tools.GetLastIdentity(ao_Db)
 
  If al_RowIdTran = 0 Then
    ls_RequestTran = Replace(ls_RequestTran, "$rowid$", mo_Tools.SqlInt(ll_RowId), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_RequestTran)
  End If
  ExportCustomerRecord = ll_RowId
  Call mo_Shell.Run("""" & ls_path & """")
  Exit Function
ErrorHandler:
  Call ErrorHandler("ExportCustomerRecord")
End Function

Private Function CreateXMLPath(ByVal as_ExportName As String, ByVal as_key As String) As String
On Error GoTo ErrorHandler
Dim ls_path As String

  ls_path = mo_Tools.GetAndCreateTempDir(mo_FSO, SCREEN_NAME)
  as_key = Replace(as_key, "\", "_", , , vbTextCompare)
  as_key = Replace(as_key, "/", "_", , , vbTextCompare)
  as_key = Replace(as_key, "$", "_", , , vbTextCompare)
  as_key = Replace(as_key, "*", "_", , , vbTextCompare)
  
  CreateXMLPath = ls_path & "\" & as_ExportName & as_key & ".XML"
  Exit Function
ErrorHandler:
  Call ErrorHandler("CreateXMLPath")
End Function

Private Sub ExportCustomerComplete(ByVal ao_Db As Object, ByVal al_RowIdTran As Long, ByVal as_CCU_Capkey As String)
On Error GoTo ErrorHandler

  Dim ls_Request As String

  ls_Request = "UPDATE tran_cus SET status_tran=$status_tran$ where rowidtran=$rowidtran$"
  ls_Request = Replace(ls_Request, "$status_tran$", mo_Tools.SQLStr(ROWIDTRANSTATUS_NEW), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("ExportCustomerComplete")
End Sub

Private Sub ExportPMasterComplete(ByVal ao_Db As Object, ByVal al_RowIdTran As Long, ByVal as_PRD_Id As String)
On Error GoTo ErrorHandler

  Dim ls_Request As String

  ls_Request = "UPDATE tran_sc SET status_tran=$status_tran$ where rowidtran=$rowidtran$"
  ls_Request = Replace(ls_Request, "$status_tran$", mo_Tools.SQLStr(ROWIDTRANSTATUS_NEW), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
  Exit Sub
ErrorHandler:
  Call ErrorHandler("ExportPMasterComplete")
End Sub

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

  as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  ReplaceCommonPlaceholders = as_Request
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

